/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.cluster.ClusterState;
import com.hazelcast.config.WanReplicationConfig;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpPostCommand;
import com.hazelcast.internal.ascii.rest.RestValue;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.management.ManagementCenterService;
import com.hazelcast.internal.management.dto.WanReplicationConfigDTO;
import com.hazelcast.internal.management.operation.SetLicenseOperation;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.InvocationUtil;
import com.hazelcast.internal.util.StringUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.UsernamePasswordCredentials;
import com.hazelcast.version.Version;
import com.hazelcast.wan.impl.AddWanConfigResult;
import com.hazelcast.wan.impl.WanReplicationService;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;

public class HttpPostCommandProcessor
extends HttpCommandProcessor<HttpPostCommand> {
    private static final byte[] QUEUE_SIMPLE_VALUE_CONTENT_TYPE = StringUtil.stringToBytes("text/plain");
    private final ILogger logger;

    public HttpPostCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
        this.logger = textCommandService.getNode().getLogger(HttpPostCommandProcessor.class);
    }

    @Override
    public void handle(HttpPostCommand command) {
        boolean sendResponse = true;
        try {
            String uri = command.getURI();
            if (uri.startsWith("/hazelcast/rest/maps/")) {
                this.handleMap(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/mancenter/changeurl")) {
                this.handleManagementCenterUrlChange(command);
            } else if (uri.startsWith("/hazelcast/rest/queues/")) {
                this.handleQueue(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/management/cluster/state")) {
                this.handleGetClusterState(command);
            } else if (uri.startsWith("/hazelcast/rest/management/cluster/changeState")) {
                this.handleChangeClusterState(command);
            } else if (uri.startsWith("/hazelcast/rest/management/cluster/version")) {
                this.handleChangeClusterVersion(command);
            } else {
                if (uri.startsWith("/hazelcast/rest/management/cluster/clusterShutdown")) {
                    this.handleClusterShutdown(command);
                    return;
                }
                if (uri.startsWith("/hazelcast/rest/management/cluster/forceStart")) {
                    this.handleForceStart(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/hotBackupInterrupt")) {
                    this.handleHotRestartBackupInterrupt(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/hotBackup")) {
                    this.handleHotRestartBackup(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/partialStart")) {
                    this.handlePartialStart(command);
                } else if (uri.startsWith("/hazelcast/rest/management/cluster/nodes")) {
                    this.handleListNodes(command);
                } else {
                    if (uri.startsWith("/hazelcast/rest/management/cluster/memberShutdown")) {
                        this.handleShutdownNode(command);
                        return;
                    }
                    if (uri.startsWith("/hazelcast/rest/mancenter/wan/sync/map") || uri.startsWith("/hazelcast/rest/wan/sync/map")) {
                        this.handleWanSyncMap(command);
                    } else if (uri.startsWith("/hazelcast/rest/mancenter/wan/sync/allmaps") || uri.startsWith("/hazelcast/rest/wan/sync/allmaps")) {
                        this.handleWanSyncAllMaps(command);
                    } else if (uri.startsWith("/hazelcast/rest/mancenter/wan/clearWanQueues") || uri.startsWith("/hazelcast/rest/mancenter/clearWanQueues")) {
                        this.handleWanClearQueues(command);
                    } else if (uri.startsWith("/hazelcast/rest/mancenter/wan/addWanConfig") || uri.startsWith("/hazelcast/rest/wan/addWanConfig")) {
                        this.handleAddWanConfig(command);
                    } else if (uri.startsWith("/hazelcast/rest/mancenter/wan/pausePublisher")) {
                        this.handleWanPausePublisher(command);
                    } else if (uri.startsWith("/hazelcast/rest/mancenter/wan/stopPublisher")) {
                        this.handleWanStopPublisher(command);
                    } else if (uri.startsWith("/hazelcast/rest/mancenter/wan/resumePublisher")) {
                        this.handleWanResumePublisher(command);
                    } else if (uri.startsWith("/hazelcast/rest/mancenter/wan/consistencyCheck/map")) {
                        this.handleWanConsistencyCheck(command);
                    } else if (uri.startsWith("/hazelcast/rest/mancenter/security/permissions")) {
                        command.send403();
                    } else if (uri.startsWith("/hazelcast/rest/cp-subsystem/members")) {
                        this.handleCPMember(command);
                        sendResponse = false;
                    } else if (uri.startsWith("/hazelcast/rest/cp-subsystem/groups")) {
                        this.handleCPGroup(command);
                        sendResponse = false;
                    } else if (uri.startsWith("/hazelcast/rest/cp-subsystem/reset")) {
                        this.handleResetCPSubsystem(command);
                        sendResponse = false;
                    } else if (uri.startsWith("/hazelcast/rest/license")) {
                        this.handleSetLicense(command);
                    } else {
                        command.send404();
                    }
                }
            }
        }
        catch (IndexOutOfBoundsException e) {
            command.send400();
        }
        catch (Exception e) {
            command.send500();
        }
        if (sendResponse) {
            this.textCommandService.sendResponse(command);
        }
    }

    private void handleChangeClusterState(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while changing cluster state", this.withAuthentication(command -> {
            byte[] data = command.getData();
            String[] strList = StringUtil.bytesToString(data).split("&");
            Node node = this.textCommandService.getNode();
            ClusterServiceImpl clusterService = node.getClusterService();
            String stateParam = URLDecoder.decode(strList[2], "UTF-8");
            ClusterState state = ClusterState.valueOf(StringUtil.upperCaseInternal(stateParam));
            if (!state.equals((Object)clusterService.getClusterState())) {
                clusterService.changeClusterState(state);
                JsonObject res = HttpPostCommandProcessor.response(ResponseType.SUCCESS, "state", state.toString().toLowerCase(StringUtil.LOCALE_INTERNAL));
                this.prepareResponse(command, res);
            } else {
                JsonObject res = HttpPostCommandProcessor.response(ResponseType.FAIL, "state", state.toString().toLowerCase(StringUtil.LOCALE_INTERNAL));
                this.prepareResponse(command, res);
            }
        })).handle(cmd);
    }

    private void handleGetClusterState(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while getting cluster state", this.withAuthentication(command -> {
            Node node = this.textCommandService.getNode();
            ClusterServiceImpl clusterService = node.getClusterService();
            ClusterState clusterState = clusterService.getClusterState();
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, "state", StringUtil.lowerCaseInternal(clusterState.toString())));
        })).handle(cmd);
    }

    private void handleChangeClusterVersion(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while changing cluster version", this.withAuthentication(command -> {
            byte[] data = command.getData();
            String[] strList = StringUtil.bytesToString(data).split("&");
            Node node = this.textCommandService.getNode();
            ClusterServiceImpl clusterService = node.getClusterService();
            String versionParam = URLDecoder.decode(strList[2], "UTF-8");
            Version version = Version.of(versionParam);
            clusterService.changeClusterVersion(version);
            JsonObject rsp = HttpPostCommandProcessor.response(ResponseType.SUCCESS, "version", clusterService.getClusterVersion().toString());
            this.prepareResponse(command, rsp);
        })).handle(cmd);
    }

    private void handleForceStart(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while handling force start", this.withAuthentication(command -> {
            Node node = this.textCommandService.getNode();
            boolean success = node.getNodeExtension().getInternalHotRestartService().triggerForceStart();
            this.prepareResponse(command, HttpPostCommandProcessor.response(success ? ResponseType.SUCCESS : ResponseType.FAIL, new String[0]));
        })).handle(cmd);
    }

    private void handlePartialStart(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while handling partial start", this.withAuthentication(command -> {
            Node node = this.textCommandService.getNode();
            boolean success = node.getNodeExtension().getInternalHotRestartService().triggerPartialStart();
            this.prepareResponse(command, HttpPostCommandProcessor.response(success ? ResponseType.SUCCESS : ResponseType.FAIL, new String[0]));
        })).handle(cmd);
    }

    private void handleHotRestartBackup(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while invoking hot backup", this.withAuthentication(command -> {
            this.textCommandService.getNode().getNodeExtension().getHotRestartService().backup();
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, new String[0]));
        })).handle(cmd);
    }

    private void handleHotRestartBackupInterrupt(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while interrupting hot backup", this.withAuthentication(command -> {
            this.textCommandService.getNode().getNodeExtension().getHotRestartService().interruptBackupTask();
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, new String[0]));
        })).handle(cmd);
    }

    private void handleClusterShutdown(HttpPostCommand command) {
        try {
            Node node = this.textCommandService.getNode();
            ClusterServiceImpl clusterService = node.getClusterService();
            if (!this.checkCredentials(command)) {
                command.send403();
                this.textCommandService.sendResponse(command);
            } else {
                this.sendResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, new String[0]));
                clusterService.shutdown();
            }
        }
        catch (Throwable throwable) {
            this.logger.warning("Error occurred while shutting down cluster", throwable);
            this.sendResponse(command, HttpPostCommandProcessor.exceptionResponse(throwable));
        }
    }

    private void handleListNodes(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while listing nodes", this.withAuthentication(command -> {
            Node node = this.textCommandService.getNode();
            ClusterServiceImpl clusterService = node.getClusterService();
            String responseTxt = clusterService.getMembers().toString() + "\n" + node.getBuildInfo().getVersion() + "\n" + System.getProperty("java.version");
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, "response", responseTxt));
        })).handle(cmd);
    }

    private void handleShutdownNode(HttpPostCommand command) {
        try {
            Node node = this.textCommandService.getNode();
            if (!this.checkCredentials(command)) {
                command.send403();
                this.textCommandService.sendResponse(command);
            } else {
                this.sendResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, new String[0]));
                node.hazelcastInstance.shutdown();
            }
        }
        catch (Throwable throwable) {
            this.logger.warning("Error occurred while shutting down", throwable);
            this.sendResponse(command, HttpPostCommandProcessor.exceptionResponse(throwable));
        }
    }

    private void handleQueue(HttpPostCommand command, String uri) {
        byte[] contentType;
        byte[] data;
        String queueName;
        String simpleValue = null;
        String suffix = uri.endsWith("/") ? uri.substring("/hazelcast/rest/queues/".length(), uri.length() - 1) : uri.substring("/hazelcast/rest/queues/".length());
        int indexSlash = suffix.lastIndexOf(47);
        if (indexSlash == -1) {
            queueName = suffix;
        } else {
            queueName = suffix.substring(0, indexSlash);
            simpleValue = suffix.substring(indexSlash + 1);
        }
        if (simpleValue == null) {
            data = command.getData();
            contentType = command.getContentType();
        } else {
            data = StringUtil.stringToBytes(simpleValue);
            contentType = QUEUE_SIMPLE_VALUE_CONTENT_TYPE;
        }
        boolean offerResult = this.textCommandService.offer(queueName, new RestValue(data, contentType));
        if (offerResult) {
            command.send200();
        } else {
            command.setResponse(HttpCommand.RES_503);
        }
    }

    private void handleManagementCenterUrlChange(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while changing management center URL", this.withAuthentication(command -> {
            String[] strList = StringUtil.bytesToString(command.getData()).split("&");
            ManagementCenterService managementCenterService = this.textCommandService.getNode().getManagementCenterService();
            if (managementCenterService != null) {
                String url = URLDecoder.decode(strList[2], "UTF-8");
                command.setResponse(managementCenterService.clusterWideUpdateManagementCenterUrl(url));
            } else {
                this.logger.warning("Unable to change URL of ManagementCenter as the ManagementCenterService is not running on this member.");
                command.send204();
            }
        })).handle(cmd);
    }

    private void handleMap(HttpPostCommand command, String uri) {
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
        String key = uri.substring(indexEnd + 1);
        byte[] data = command.getData();
        this.textCommandService.put(mapName, key, new RestValue(data, command.getContentType()), -1);
        command.send200();
    }

    private void handleWanSyncMap(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while syncing map", this.withAuthentication(command -> {
            String[] params = HttpPostCommandProcessor.decodeParams(command, 5);
            String wanRepName = params[2];
            String publisherId = params[3];
            String mapName = params[4];
            UUID uuid = this.textCommandService.getNode().getNodeEngine().getWanReplicationService().syncMap(wanRepName, publisherId, mapName);
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, "message", "Sync initiated", "uuid", uuid.toString()));
        })).handle(cmd);
    }

    private void handleWanSyncAllMaps(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while syncing maps", this.withAuthentication(command -> {
            String[] params = HttpPostCommandProcessor.decodeParams(command, 4);
            String wanRepName = params[2];
            String publisherId = params[3];
            UUID uuid = this.textCommandService.getNode().getNodeEngine().getWanReplicationService().syncAllMaps(wanRepName, publisherId);
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, "message", "Sync initiated", "uuid", uuid.toString()));
        })).handle(cmd);
    }

    private void handleWanConsistencyCheck(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while syncing maps", this.withAuthentication(command -> {
            String[] params = HttpPostCommandProcessor.decodeParams(command, 5);
            String wanReplicationName = params[2];
            String publisherId = params[3];
            String mapName = params[4];
            WanReplicationService service = this.textCommandService.getNode().getNodeEngine().getWanReplicationService();
            UUID uuid = service.consistencyCheck(wanReplicationName, publisherId, mapName);
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, "message", "Consistency check initiated", "uuid", uuid.toString()));
        })).handle(cmd);
    }

    private void handleWanClearQueues(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while clearing queues", this.withAuthentication(command -> {
            String[] params = HttpPostCommandProcessor.decodeParams(command, 4);
            String wanRepName = params[2];
            String publisherId = params[3];
            this.textCommandService.getNode().getNodeEngine().getWanReplicationService().removeWanEvents(wanRepName, publisherId);
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, "message", "WAN replication queues are cleared."));
        })).handle(cmd);
    }

    private void handleAddWanConfig(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while adding WAN config", this.withAuthentication(command -> {
            String[] params = HttpPostCommandProcessor.decodeParams(command, 3);
            String wanConfigJson = params[2];
            WanReplicationConfigDTO dto = new WanReplicationConfigDTO(new WanReplicationConfig());
            dto.fromJson(Json.parse(wanConfigJson).asObject());
            AddWanConfigResult result = this.textCommandService.getNode().getNodeEngine().getWanReplicationService().addWanReplicationConfig(dto.getConfig());
            JsonObject res = HttpPostCommandProcessor.response(ResponseType.SUCCESS, "message", "WAN configuration added.");
            res.add("addedPublisherIds", Json.array(result.getAddedPublisherIds().toArray(new String[0])));
            res.add("ignoredPublisherIds", Json.array(result.getIgnoredPublisherIds().toArray(new String[0])));
            this.prepareResponse(command, res);
        })).handle(cmd);
    }

    private void handleWanPausePublisher(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while pausing WAN publisher", this.withAuthentication(command -> {
            String[] params = HttpPostCommandProcessor.decodeParams(command, 4);
            String wanReplicationName = params[2];
            String publisherId = params[3];
            WanReplicationService service = this.textCommandService.getNode().getNodeEngine().getWanReplicationService();
            service.pause(wanReplicationName, publisherId);
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, "message", "WAN publisher paused"));
        })).handle(cmd);
    }

    private void handleWanStopPublisher(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while stopping WAN publisher", this.withAuthentication(command -> {
            String[] params = HttpPostCommandProcessor.decodeParams(command, 4);
            String wanReplicationName = params[2];
            String publisherId = params[3];
            WanReplicationService service = this.textCommandService.getNode().getNodeEngine().getWanReplicationService();
            service.stop(wanReplicationName, publisherId);
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, "message", "WAN publisher stopped"));
        })).handle(cmd);
    }

    private void handleWanResumePublisher(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while stopping WAN publisher", this.withAuthentication(command -> {
            String[] params = HttpPostCommandProcessor.decodeParams(command, 4);
            String wanReplicationName = params[2];
            String publisherId = params[3];
            WanReplicationService service = this.textCommandService.getNode().getNodeEngine().getWanReplicationService();
            service.resume(wanReplicationName, publisherId);
            this.prepareResponse(command, HttpPostCommandProcessor.response(ResponseType.SUCCESS, "message", "WAN publisher resumed"));
        })).handle(cmd);
    }

    private void handleCPMember(HttpPostCommand command) throws UnsupportedEncodingException {
        if (!this.checkCredentials(command)) {
            command.send403();
            this.textCommandService.sendResponse(command);
            return;
        }
        String uri = command.getURI();
        if (uri.endsWith("/remove") || uri.endsWith("/remove/")) {
            this.handleRemoveCPMember(command);
        } else {
            this.handlePromoteToCPMember(command);
        }
    }

    private void handlePromoteToCPMember(HttpPostCommand command) {
        if (this.getCpSubsystem().getLocalCPMember() != null) {
            command.send200();
            this.textCommandService.sendResponse(command);
            return;
        }
        this.getCpSubsystemManagementService().promoteToCPMember().whenCompleteAsync((response, t) -> {
            if (t == null) {
                command.send200();
                this.textCommandService.sendResponse(command);
            } else {
                this.logger.warning("Error while promoting CP member.", (Throwable)t);
                command.send500();
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleRemoveCPMember(HttpPostCommand command) {
        String uri = command.getURI();
        String prefix = "/hazelcast/rest/cp-subsystem/members/";
        UUID cpMemberUid = UUID.fromString(uri.substring(prefix.length(), uri.indexOf(47, prefix.length())).trim());
        this.getCpSubsystem().getCPSubsystemManagementService().removeCPMember(cpMemberUid).whenCompleteAsync((respone, t) -> {
            if (t == null) {
                command.send200();
                this.textCommandService.sendResponse(command);
            } else {
                this.logger.warning("Error while removing CP member " + cpMemberUid, (Throwable)t);
                if (ExceptionUtil.peel(t) instanceof IllegalArgumentException) {
                    command.send400();
                } else {
                    command.send500();
                }
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleCPGroup(HttpPostCommand command) throws UnsupportedEncodingException {
        if (!this.checkCredentials(command)) {
            command.send403();
            this.textCommandService.sendResponse(command);
            return;
        }
        String uri = command.getURI();
        if (!uri.endsWith("/remove") && !uri.endsWith("/remove/")) {
            command.send404();
            this.textCommandService.sendResponse(command);
            return;
        }
        if (uri.contains("/sessions")) {
            this.handleForceCloseCPSession(command);
        } else {
            this.handleForceDestroyCPGroup(command);
        }
    }

    private void handleForceCloseCPSession(HttpPostCommand command) {
        String uri = command.getURI();
        String prefix = "/hazelcast/rest/cp-subsystem/groups/";
        String suffix = "/sessions/";
        int i = uri.indexOf(suffix);
        String groupName = uri.substring(prefix.length(), i).trim();
        long sessionId = Long.parseLong(uri.substring(i + suffix.length(), uri.indexOf(47, i + suffix.length())));
        this.getCpSubsystem().getCPSessionManagementService().forceCloseSession(groupName, sessionId).whenCompleteAsync((response, t) -> {
            if (t == null) {
                if (response.booleanValue()) {
                    command.send200();
                } else {
                    command.send400();
                }
                this.textCommandService.sendResponse(command);
            } else {
                this.logger.warning("Error while closing CP session", (Throwable)t);
                command.send500();
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleForceDestroyCPGroup(HttpPostCommand command) {
        String prefix;
        String uri = command.getURI();
        String groupName = uri.substring((prefix = "/hazelcast/rest/cp-subsystem/groups/").length(), uri.indexOf(47, prefix.length())).trim();
        if ("METADATA".equals(groupName)) {
            command.send400();
            this.textCommandService.sendResponse(command);
            return;
        }
        this.getCpSubsystem().getCPSubsystemManagementService().forceDestroyCPGroup(groupName).whenCompleteAsync((response, t) -> {
            if (t == null) {
                command.send200();
                this.textCommandService.sendResponse(command);
            } else {
                this.logger.warning("Error while destroying CP group " + groupName, (Throwable)t);
                if (ExceptionUtil.peel(t) instanceof IllegalArgumentException) {
                    command.send400();
                } else {
                    command.send500();
                }
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleResetCPSubsystem(HttpPostCommand command) throws UnsupportedEncodingException {
        if (this.checkCredentials(command)) {
            this.getCpSubsystem().getCPSubsystemManagementService().reset().whenCompleteAsync((response, t) -> {
                if (t == null) {
                    command.send200();
                    this.textCommandService.sendResponse(command);
                } else {
                    this.logger.warning("Error while resetting CP subsystem", (Throwable)t);
                    command.send500();
                    this.textCommandService.sendResponse(command);
                }
            });
        } else {
            command.send403();
            this.textCommandService.sendResponse(command);
        }
    }

    private CPSubsystemManagementService getCpSubsystemManagementService() {
        return this.getCpSubsystem().getCPSubsystemManagementService();
    }

    private CPSubsystem getCpSubsystem() {
        return this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getCPSubsystem();
    }

    private static JsonObject exceptionResponse(Throwable throwable) {
        return HttpPostCommandProcessor.response(ResponseType.FAIL, "message", throwable.getMessage());
    }

    protected static JsonObject response(ResponseType type, String ... attributes) {
        JsonObject object = new JsonObject().add("status", type.toString());
        if (attributes.length > 0) {
            int i = 0;
            while (i < attributes.length) {
                String value;
                String key = attributes[i++];
                if ((value = attributes[i++]) == null) continue;
                object.add(key, value);
            }
        }
        return object;
    }

    private static String[] decodeParams(HttpPostCommand command, int paramCount) throws UnsupportedEncodingException {
        byte[] data = command.getData();
        String[] encoded = StringUtil.bytesToString(data).split("&");
        String[] decoded = new String[encoded.length];
        for (int i = 0; i < paramCount; ++i) {
            decoded[i] = URLDecoder.decode(encoded[i], "UTF-8");
        }
        return decoded;
    }

    private boolean checkCredentials(HttpPostCommand command) throws UnsupportedEncodingException {
        byte[] data = command.getData();
        if (data == null) {
            return false;
        }
        String[] strList = StringUtil.bytesToString(data).split("&", -1);
        return this.authenticate(command, strList[0], strList.length > 1 ? strList[1] : null);
    }

    private boolean authenticate(HttpPostCommand command, String userName, String pass) throws UnsupportedEncodingException {
        String decodedName = userName != null ? URLDecoder.decode(userName, "UTF-8") : null;
        Node node = this.textCommandService.getNode();
        SecurityContext securityContext = node.getNodeExtension().getSecurityContext();
        String clusterName = node.getConfig().getClusterName();
        if (securityContext == null) {
            if (pass != null && !pass.isEmpty()) {
                this.logger.fine("Password was provided but the Hazelcast Security is disabled.");
            }
            return clusterName.equals(decodedName);
        }
        String decodedPass = pass != null ? URLDecoder.decode(pass, "UTF-8") : null;
        UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(decodedName, decodedPass);
        try {
            LoginContext lc = securityContext.createMemberLoginContext(decodedName, credentials, command.getConnection());
            lc.login();
        }
        catch (LoginException e) {
            return false;
        }
        return true;
    }

    protected void sendResponse(HttpPostCommand command, JsonObject json) {
        this.prepareResponse(command, json);
        this.textCommandService.sendResponse(command);
    }

    @Override
    public void handleRejection(HttpPostCommand command) {
        this.handle(command);
    }

    private void handleSetLicense(HttpPostCommand cmd) {
        this.withExceptionHandling("Error occurred while updating the license", this.withAuthentication(command -> {
            try {
                int retryCount = 100;
                byte[] data = command.getData();
                String[] strList = StringUtil.bytesToString(data).split("&");
                String licenseKey = strList.length > 2 ? URLDecoder.decode(strList[2], "UTF-8") : null;
                InvocationUtil.invokeOnStableClusterSerial(this.textCommandService.getNode().nodeEngine, () -> new SetLicenseOperation(licenseKey), 100).get();
                this.prepareResponse(command, this.responseOnSetLicenseSuccess());
            }
            catch (ExecutionException executionException) {
                this.logger.warning("Error occurred while updating the license", executionException.getCause());
                this.prepareResponse(command, HttpPostCommandProcessor.exceptionResponse(executionException.getCause()));
            }
        })).handle(cmd);
    }

    private ExceptionThrowingCommandHandler withAuthentication(ExceptionThrowingCommandHandler commandHandler) {
        return command -> {
            if (this.checkCredentials(command)) {
                commandHandler.handle(command);
            } else {
                command.send403();
            }
        };
    }

    private CommandHandler withExceptionHandling(String errorMsg, ExceptionThrowingCommandHandler commandHandler) {
        return cmd -> {
            try {
                commandHandler.handle(cmd);
            }
            catch (Throwable throwable) {
                this.logger.warning(errorMsg, throwable);
                this.prepareResponse(cmd, HttpPostCommandProcessor.exceptionResponse(throwable));
            }
        };
    }

    protected JsonObject responseOnSetLicenseSuccess() {
        return HttpPostCommandProcessor.response(ResponseType.SUCCESS, new String[0]);
    }

    private static interface ExceptionThrowingCommandHandler {
        public void handle(HttpPostCommand var1) throws Throwable;
    }

    private static interface CommandHandler {
        public void handle(HttpPostCommand var1);
    }

    protected static enum ResponseType {
        SUCCESS,
        FAIL;


        public String toString() {
            return super.toString().toLowerCase(StringUtil.LOCALE_INTERNAL);
        }
    }
}

