/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.ascii.rest;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.ClusterState;
import com.hazelcast.cp.CPGroup;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.session.CPSession;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeState;
import com.hazelcast.internal.ascii.TextCommandService;
import com.hazelcast.internal.ascii.rest.HttpCommand;
import com.hazelcast.internal.ascii.rest.HttpCommandProcessor;
import com.hazelcast.internal.ascii.rest.HttpGetCommand;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.json.Json;
import com.hazelcast.internal.json.JsonArray;
import com.hazelcast.internal.json.JsonObject;
import com.hazelcast.internal.nio.AggregateEndpointManager;
import com.hazelcast.internal.nio.EndpointManager;
import com.hazelcast.internal.nio.NetworkingService;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.StringUtil;
import java.util.Collection;
import java.util.concurrent.CompletionStage;

public class HttpGetCommandProcessor
extends HttpCommandProcessor<HttpGetCommand> {
    public static final String QUEUE_SIZE_COMMAND = "size";
    private static final String HEALTH_PATH_PARAM_NODE_STATE = "/node-state";
    private static final String HEALTH_PATH_PARAM_CLUSTER_STATE = "/cluster-state";
    private static final String HEALTH_PATH_PARAM_CLUSTER_SAFE = "/cluster-safe";
    private static final String HEALTH_PATH_PARAM_MIGRATION_QUEUE_SIZE = "/migration-queue-size";
    private static final String HEALTH_PATH_PARAM_CLUSTER_SIZE = "/cluster-size";

    public HttpGetCommandProcessor(TextCommandService textCommandService) {
        super(textCommandService);
    }

    @Override
    public void handle(HttpGetCommand command) {
        boolean sendResponse = true;
        try {
            String uri = command.getURI();
            if (uri.startsWith("/hazelcast/rest/maps/")) {
                this.handleMap(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/queues/")) {
                this.handleQueue(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/instance")) {
                this.handleInstance(command);
            } else if (uri.startsWith("/hazelcast/rest/cluster")) {
                this.handleCluster(command);
            } else if (uri.startsWith("/hazelcast/health/ready")) {
                this.handleHealthReady(command);
            } else if (uri.startsWith("/hazelcast/health")) {
                this.handleHealthcheck(command, uri);
            } else if (uri.startsWith("/hazelcast/rest/management/cluster/version")) {
                this.handleGetClusterVersion(command);
            } else if (uri.startsWith("/hazelcast/rest/license")) {
                this.handleLicense(command);
            } else if (uri.startsWith("/hazelcast/rest/cp-subsystem/groups")) {
                this.handleCPGroupRequest(command);
                sendResponse = false;
            } else if (uri.startsWith("/hazelcast/rest/cp-subsystem/members/local")) {
                this.handleGetLocalCPMember(command);
            } else if (uri.startsWith("/hazelcast/rest/cp-subsystem/members")) {
                this.handleGetCPMembers(command);
                sendResponse = false;
            } else {
                command.send404();
            }
        }
        catch (IndexOutOfBoundsException e) {
            command.send400();
        }
        catch (Exception e) {
            command.send500();
        }
        if (sendResponse) {
            this.textCommandService.sendResponse(command);
        }
    }

    private void handleHealthReady(HttpGetCommand command) {
        Node node = this.textCommandService.getNode();
        if (node.isRunning() && node.getNodeExtension().isStartCompleted()) {
            command.setResponse(HttpCommand.RES_200_WITH_NO_CONTENT);
        } else {
            command.setResponse(HttpCommand.RES_503);
        }
    }

    private void handleHealthcheck(HttpGetCommand command, String uri) {
        Node node = this.textCommandService.getNode();
        NodeState nodeState = node.getState();
        ClusterServiceImpl clusterService = node.getClusterService();
        ClusterState clusterState = clusterService.getClusterState();
        int clusterSize = clusterService.getMembers().size();
        InternalPartitionService partitionService = node.getPartitionService();
        boolean memberStateSafe = partitionService.isMemberStateSafe();
        boolean clusterSafe = memberStateSafe && !partitionService.hasOnGoingMigration();
        long migrationQueueSize = partitionService.getMigrationQueueSize();
        String healthParameter = uri.substring("/hazelcast/health".length());
        if (healthParameter.equals(HEALTH_PATH_PARAM_NODE_STATE)) {
            if (NodeState.SHUT_DOWN.equals((Object)nodeState)) {
                command.setResponse(HttpCommand.RES_503);
            } else {
                this.prepareResponse(command, Json.value(nodeState.toString()));
            }
        } else if (healthParameter.equals(HEALTH_PATH_PARAM_CLUSTER_STATE)) {
            this.prepareResponse(command, Json.value(clusterState.toString()));
        } else if (healthParameter.equals(HEALTH_PATH_PARAM_CLUSTER_SAFE)) {
            if (clusterSafe) {
                command.send200();
            } else {
                command.setResponse(HttpCommand.RES_503);
            }
        } else if (healthParameter.equals(HEALTH_PATH_PARAM_MIGRATION_QUEUE_SIZE)) {
            this.prepareResponse(command, Json.value(migrationQueueSize));
        } else if (healthParameter.equals(HEALTH_PATH_PARAM_CLUSTER_SIZE)) {
            this.prepareResponse(command, Json.value(clusterSize));
        } else if (healthParameter.isEmpty()) {
            JsonObject response = new JsonObject().add("nodeState", nodeState.toString()).add("clusterState", clusterState.toString()).add("clusterSafe", clusterSafe).add("migrationQueueSize", migrationQueueSize).add("clusterSize", clusterSize);
            this.prepareResponse(command, response);
        } else {
            command.send400();
        }
    }

    private static String booleanToString(boolean b) {
        return Boolean.toString(b).toUpperCase(StringUtil.LOCALE_INTERNAL);
    }

    private void handleGetClusterVersion(HttpGetCommand command) {
        Node node = this.textCommandService.getNode();
        ClusterServiceImpl clusterService = node.getClusterService();
        JsonObject response = new JsonObject().add("status", "success").add("version", clusterService.getClusterVersion().toString());
        this.prepareResponse(command, response);
    }

    private void handleCPGroupRequest(HttpGetCommand command) {
        String uri = command.getURI();
        if (uri.contains("/sessions")) {
            this.handleGetCPSessions(command);
        } else if (uri.endsWith("/hazelcast/rest/cp-subsystem/groups") || uri.endsWith("/hazelcast/rest/cp-subsystem/groups/")) {
            this.handleGetCPGroupIds(command);
        } else {
            this.handleGetCPGroupByName(command);
        }
    }

    private void handleGetCPGroupIds(HttpGetCommand command) {
        CompletionStage<Collection<CPGroupId>> f = this.getCpSubsystemManagementService().getCPGroupIds();
        f.whenCompleteAsync((groupIds, t) -> {
            if (t == null) {
                JsonArray arr = new JsonArray();
                for (CPGroupId groupId : groupIds) {
                    arr.add(this.toJson(groupId));
                }
                this.prepareResponse(command, arr);
                this.textCommandService.sendResponse(command);
            } else {
                command.send500();
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleGetCPSessions(HttpGetCommand command) {
        String uri = command.getURI();
        String prefix = "/hazelcast/rest/cp-subsystem/groups/";
        int i = uri.indexOf("/sessions");
        String groupName = uri.substring(prefix.length(), i).trim();
        this.getCpSubsystem().getCPSessionManagementService().getAllSessions(groupName).whenCompleteAsync((sessions, t) -> {
            if (t == null) {
                JsonArray sessionsArr = new JsonArray();
                for (CPSession session : sessions) {
                    sessionsArr.add(this.toJson(session));
                }
                this.prepareResponse(command, sessionsArr);
                this.textCommandService.sendResponse(command);
            } else {
                if (ExceptionUtil.peel(t) instanceof IllegalArgumentException) {
                    command.send404();
                } else {
                    command.send500();
                }
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleGetCPGroupByName(HttpGetCommand command) {
        String prefix = "/hazelcast/rest/cp-subsystem/groups/";
        String groupName = command.getURI().substring(prefix.length()).trim();
        CompletionStage<CPGroup> f = this.getCpSubsystemManagementService().getCPGroup(groupName);
        f.whenCompleteAsync((group, t) -> {
            if (t == null) {
                if (group != null) {
                    JsonObject json = new JsonObject();
                    json.add("id", this.toJson(group.id())).add("status", group.status().name());
                    JsonArray membersArr = new JsonArray();
                    for (CPMember member : group.members()) {
                        membersArr.add(this.toJson(member));
                    }
                    json.add("members", membersArr);
                    this.prepareResponse(command, json);
                } else {
                    command.send404();
                }
                this.textCommandService.sendResponse(command);
            } else {
                command.send500();
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleGetCPMembers(HttpGetCommand command) {
        CompletionStage<Collection<CPMember>> f = this.getCpSubsystemManagementService().getCPMembers();
        f.whenCompleteAsync((cpMembers, t) -> {
            if (t == null) {
                JsonArray arr = new JsonArray();
                for (CPMember cpMember : cpMembers) {
                    arr.add(this.toJson(cpMember));
                }
                this.prepareResponse(command, arr);
                this.textCommandService.sendResponse(command);
            } else {
                command.send500();
                this.textCommandService.sendResponse(command);
            }
        });
    }

    private void handleGetLocalCPMember(HttpGetCommand command) {
        CPMember localCPMember = this.getCpSubsystem().getLocalCPMember();
        if (localCPMember != null) {
            this.prepareResponse(command, this.toJson(localCPMember));
        } else {
            command.send404();
        }
    }

    private CPSubsystemManagementService getCpSubsystemManagementService() {
        return this.getCpSubsystem().getCPSubsystemManagementService();
    }

    private CPSubsystem getCpSubsystem() {
        return this.textCommandService.getNode().getNodeEngine().getHazelcastInstance().getCPSubsystem();
    }

    private JsonObject toJson(CPGroupId groupId) {
        return new JsonObject().add("name", groupId.getName()).add("id", groupId.getId());
    }

    private JsonObject toJson(CPMember cpMember) {
        Address address = cpMember.getAddress();
        return new JsonObject().add("uuid", cpMember.getUuid().toString()).add("address", "[" + address.getHost() + "]:" + address.getPort());
    }

    private JsonObject toJson(CPSession cpSession) {
        Address address = cpSession.endpoint();
        return new JsonObject().add("id", cpSession.id()).add("creationTime", cpSession.creationTime()).add("expirationTime", cpSession.expirationTime()).add("version", cpSession.version()).add("endpoint", "[" + address.getHost() + "]:" + address.getPort()).add("endpointType", cpSession.endpointType().name()).add("endpointName", cpSession.endpointName());
    }

    private void handleCluster(HttpGetCommand command) {
        Node node = this.textCommandService.getNode();
        NetworkingService ns = node.getNetworkingService();
        EndpointManager cem = ns.getEndpointManager(EndpointQualifier.CLIENT);
        AggregateEndpointManager aem = ns.getAggregateEndpointManager();
        ClusterServiceImpl clusterService = node.getClusterService();
        JsonArray membersArray = new JsonArray();
        clusterService.getMembers().stream().map(m -> new JsonObject().add("address", m.getAddress().toString()).add("liteMember", m.isLiteMember()).add("localMember", m.localMember()).add("uuid", m.getUuid().toString()).add("memberVersion", m.getVersion().toString())).forEach(membersArray::add);
        JsonObject response = new JsonObject().add("members", membersArray).add("connectionCount", cem == null ? 0 : cem.getActiveConnections().size()).add("allConnectionCount", aem.getActiveConnections().size());
        this.prepareResponse(command, response);
    }

    private void handleInstance(HttpGetCommand command) {
        this.prepareResponse(command, new JsonObject().add("name", this.textCommandService.getInstanceName()));
    }

    private void handleQueue(HttpGetCommand command, String uri) {
        String secondStr;
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/queues/".length());
        String queueName = uri.substring("/hazelcast/rest/queues/".length(), indexEnd);
        String string = secondStr = uri.length() > indexEnd + 1 ? uri.substring(indexEnd + 1) : null;
        if (QUEUE_SIZE_COMMAND.equalsIgnoreCase(secondStr)) {
            int size = this.textCommandService.size(queueName);
            this.prepareResponse(command, Integer.toString(size));
        } else {
            int seconds = secondStr == null ? 0 : Integer.parseInt(secondStr);
            Object value = this.textCommandService.poll(queueName, seconds);
            this.prepareResponse(command, value);
        }
    }

    private void handleMap(HttpGetCommand command, String uri) {
        int indexEnd = uri.indexOf(47, "/hazelcast/rest/maps/".length());
        String mapName = uri.substring("/hazelcast/rest/maps/".length(), indexEnd);
        String key = uri.substring(indexEnd + 1);
        Object value = this.textCommandService.get(mapName, key);
        this.prepareResponse(command, value);
    }

    @Override
    public void handleRejection(HttpGetCommand command) {
        this.handle(command);
    }

    protected void handleLicense(HttpGetCommand command) {
        command.send404();
    }
}

