/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance.impl;

import com.hazelcast.cache.impl.HazelcastInstanceCacheManager;
import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.ClientService;
import com.hazelcast.client.impl.ClientServiceProxy;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.Member;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.internal.CPSubsystemImpl;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.impl.HazelcastManagedContext;
import com.hazelcast.instance.impl.LifecycleServiceImpl;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.instance.impl.NodeContext;
import com.hazelcast.internal.jmx.ManagementService;
import com.hazelcast.internal.memory.MemoryStats;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.spi.impl.proxyservice.InternalProxyService;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionManagerService;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.annotation.Nonnull;

public class HazelcastInstanceImpl
implements HazelcastInstance,
SerializationServiceSupport {
    public final Node node;
    final ConcurrentMap<String, Object> userContext = new ConcurrentHashMap<String, Object>();
    final ILogger logger;
    final String name;
    final ManagementService managementService;
    final LifecycleServiceImpl lifecycleService;
    final CPSubsystemImpl cpSubsystem;
    final ManagedContext managedContext;
    final HazelcastInstanceCacheManager hazelcastCacheManager;

    protected HazelcastInstanceImpl(String name, Config config, NodeContext nodeContext) {
        this.name = name;
        this.lifecycleService = new LifecycleServiceImpl(this);
        ManagedContext configuredManagedContext = config.getManagedContext();
        this.managedContext = new HazelcastManagedContext(this, configuredManagedContext);
        this.userContext.putAll(config.getUserContext());
        this.node = this.createNode(config, nodeContext);
        this.cpSubsystem = new CPSubsystemImpl(this);
        try {
            this.logger = this.node.getLogger(this.getClass().getName());
            this.node.start();
            if (!this.node.isRunning()) {
                throw new IllegalStateException("Node failed to start!");
            }
            this.managementService = this.node.getNodeExtension().createJMXManagementService(this);
            this.initManagedContext(configuredManagedContext);
            this.hazelcastCacheManager = new HazelcastInstanceCacheManager(this);
            ClassLoader classLoader = this.node.getConfigClassLoader();
            if (classLoader instanceof HazelcastInstanceAware) {
                ((HazelcastInstanceAware)((Object)classLoader)).setHazelcastInstance(this);
            }
        }
        catch (Throwable e) {
            try {
                this.node.shutdown(true);
            }
            catch (Throwable ignored) {
                EmptyStatement.ignore(ignored);
            }
            throw ExceptionUtil.rethrow(e);
        }
    }

    private Node createNode(Config config, NodeContext nodeContext) {
        return new Node(this, config, nodeContext);
    }

    private void initManagedContext(ManagedContext configuredManagedContext) {
        if (configuredManagedContext != null && configuredManagedContext instanceof HazelcastInstanceAware) {
            ((HazelcastInstanceAware)((Object)configuredManagedContext)).setHazelcastInstance(this);
        }
    }

    public ManagementService getManagementService() {
        return this.managementService;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a map instance with a null name is not allowed!");
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    @Override
    @Nonnull
    public <E> IQueue<E> getQueue(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a queue instance with a null name is not allowed!");
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getTopic(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:reliableTopicService", name);
    }

    @Override
    @Nonnull
    public <E> ISet<E> getSet(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a set instance with a null name is not allowed!");
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a list instance with a null name is not allowed!");
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    @Override
    @Nonnull
    public <K, V> MultiMap<K, V> getMultiMap(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a multi-map instance with a null name is not allowed!");
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    @Override
    @Nonnull
    public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a ringbuffer instance with a null name is not allowed!");
        return (Ringbuffer)this.getDistributedObject("hz:impl:ringbufferService", name);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.executeTransaction(TransactionOptions.getDefault(), task);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
        TransactionManagerService transactionManagerService = this.node.getNodeEngine().getTransactionManagerService();
        return transactionManagerService.executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.newTransactionContext(TransactionOptions.getDefault());
    }

    @Override
    public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
        Preconditions.checkNotNull(options, "TransactionOptions must not be null!");
        TransactionManagerService transactionManagerService = this.node.getNodeEngine().getTransactionManagerService();
        return transactionManagerService.newTransactionContext(options);
    }

    @Override
    @Nonnull
    public IExecutorService getExecutorService(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an executor instance with a null name is not allowed!");
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    @Override
    @Nonnull
    public DurableExecutorService getDurableExecutorService(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a durable executor instance with a null name is not allowed!");
        return (DurableExecutorService)this.getDistributedObject("hz:impl:durableExecutorService", name);
    }

    @Override
    @Nonnull
    public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a Flake ID-generator instance with a null name is not allowed!");
        return (FlakeIdGenerator)this.getDistributedObject("hz:impl:flakeIdGeneratorService", name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a replicated map instance with a null name is not allowed!");
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    @Override
    public HazelcastInstanceCacheManager getCacheManager() {
        return this.hazelcastCacheManager;
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return this.node.getClusterService();
    }

    @Override
    @Nonnull
    public Member getLocalEndpoint() {
        return this.node.getLocalMember();
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        InternalProxyService proxyService = this.node.getNodeEngine().getProxyService();
        return proxyService.getAllDistributedObjects();
    }

    @Override
    @Nonnull
    public Config getConfig() {
        return this.node.getConfig();
    }

    @Override
    @Nonnull
    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    @Override
    @Nonnull
    public PartitionService getPartitionService() {
        return this.node.getPartitionService().getPartitionServiceProxy();
    }

    @Override
    @Nonnull
    public SplitBrainProtectionService getSplitBrainProtectionService() {
        return this.node.getNodeEngine().getSplitBrainProtectionService();
    }

    @Override
    @Nonnull
    public ClientService getClientService() {
        return new ClientServiceProxy(this.node);
    }

    @Override
    @Nonnull
    public LoggingService getLoggingService() {
        return this.node.getLoggingService();
    }

    @Override
    @Nonnull
    public LifecycleServiceImpl getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    @Override
    @Nonnull
    public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
        InternalProxyService proxyService = this.node.getNodeEngine().getProxyService();
        return (T)proxyService.getDistributedObject(serviceName, name);
    }

    @Override
    public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
        Preconditions.checkNotNull(distributedObjectListener, "DistributedObjectListener must not be null!");
        InternalProxyService proxyService = this.node.getNodeEngine().getProxyService();
        return proxyService.addProxyListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "Registration ID must not be null!");
        InternalProxyService proxyService = this.node.getNodeEngine().getProxyService();
        return proxyService.removeProxyListener(registrationId);
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.node.getSerializationService();
    }

    public MemoryStats getMemoryStats() {
        return this.node.getNodeExtension().getMemoryStats();
    }

    @Override
    @Nonnull
    public HazelcastXAResource getXAResource() {
        return (HazelcastXAResource)this.getDistributedObject("hz:impl:xaService", "hz:impl:xaService");
    }

    @Override
    @Nonnull
    public CardinalityEstimator getCardinalityEstimator(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a cardinality estimator instance with a null name is not allowed!");
        return (CardinalityEstimator)this.getDistributedObject("hz:impl:cardinalityEstimatorService", name);
    }

    @Override
    @Nonnull
    public PNCounter getPNCounter(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a PN counter instance with a null name is not allowed!");
        return (PNCounter)this.getDistributedObject("hz:impl:PNCounterService", name);
    }

    @Override
    @Nonnull
    public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a scheduled executor instance with a null name is not allowed!");
        return (IScheduledExecutorService)this.getDistributedObject("hz:impl:scheduledExecutorService", name);
    }

    @Override
    @Nonnull
    public CPSubsystem getCPSubsystem() {
        return this.cpSubsystem;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HazelcastInstance)) {
            return false;
        }
        HazelcastInstance that = (HazelcastInstance)o;
        return !(this.name == null ? that.getName() != null : !this.name.equals(that.getName()));
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "HazelcastInstance{name='" + this.name + "', node=" + this.node.getThisAddress() + '}';
    }
}

