/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation;

import com.hazelcast.core.MemberLeftException;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.internal.CPMemberInfo;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.RaftSystemOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.exception.TargetNotMemberException;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import com.hazelcast.spi.impl.operationservice.CallStatus;
import com.hazelcast.spi.impl.operationservice.ExceptionAction;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import java.util.function.BiConsumer;

public class TransferLeadershipOp
extends Operation
implements RaftSystemOperation,
IdentifiedDataSerializable,
BiConsumer<Object, Throwable> {
    private CPGroupId groupId;
    private CPMember destination;

    public TransferLeadershipOp() {
    }

    public TransferLeadershipOp(CPGroupId groupId, CPMember destination) {
        this.groupId = groupId;
        this.destination = destination;
    }

    @Override
    public CallStatus call() throws Exception {
        RaftService service = (RaftService)this.getService();
        InternalCompletableFuture future = service.transferLeadership(this.groupId, (CPMemberInfo)this.destination);
        future.whenCompleteAsync((BiConsumer)this);
        return CallStatus.DONE_VOID;
    }

    @Override
    public void accept(Object response, Throwable throwable) {
        if (throwable == null) {
            this.sendResponse(response);
        } else {
            this.sendResponse(throwable);
        }
    }

    @Override
    public final boolean validatesTarget() {
        return false;
    }

    @Override
    public ExceptionAction onInvocationException(Throwable throwable) {
        if (throwable instanceof MemberLeftException || throwable instanceof TargetNotMemberException) {
            return ExceptionAction.THROW_EXCEPTION;
        }
        return super.onInvocationException(throwable);
    }

    @Override
    public final String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 49;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        out.writeObject(this.groupId);
        out.writeObject(this.destination);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        this.groupId = (CPGroupId)in.readObject();
        this.destination = (CPMember)in.readObject();
    }
}

