/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.datastructures.spi.blocking;

import com.hazelcast.cluster.Address;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.internal.datastructures.spi.blocking.BlockingResource;
import com.hazelcast.cp.internal.datastructures.spi.blocking.WaitKey;
import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UUIDSerializationUtil;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.spi.exception.DistributedObjectDestroyedException;
import com.hazelcast.spi.impl.operationservice.LiveOperations;
import com.hazelcast.spi.impl.operationservice.LiveOperationsTracker;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class ResourceRegistry<W extends WaitKey, R extends BlockingResource<W>>
implements LiveOperationsTracker,
DataSerializable {
    protected CPGroupId groupId;
    protected final Map<String, R> resources = new ConcurrentHashMap<String, R>();
    protected final Set<String> destroyedNames = new HashSet<String>();
    protected final ConcurrentMap<BiTuple<String, UUID>, BiTuple<Long, Long>> waitTimeouts = new ConcurrentHashMap<BiTuple<String, UUID>, BiTuple<Long, Long>>();
    private final Set<BiTuple<Address, Long>> liveOperationsSet = Collections.newSetFromMap(new ConcurrentHashMap());

    protected ResourceRegistry() {
    }

    protected ResourceRegistry(CPGroupId groupId) {
        this.groupId = groupId;
    }

    protected abstract R createNewResource(CPGroupId var1, String var2);

    protected abstract ResourceRegistry<W, R> cloneForSnapshot();

    public final R getResourceOrNull(String name) {
        this.checkNotDestroyed(name);
        return (R)((BlockingResource)this.resources.get(name));
    }

    protected final R getOrInitResource(String name) {
        this.checkNotDestroyed(name);
        BlockingResource<Object> resource = (BlockingResource)this.resources.get(name);
        if (resource == null) {
            resource = this.createNewResource(this.groupId, name);
            this.resources.put(name, resource);
        }
        return (R)resource;
    }

    private void checkNotDestroyed(String name) {
        Preconditions.checkNotNull(name);
        if (this.destroyedNames.contains(name)) {
            throw new DistributedObjectDestroyedException("Resource[" + name + "] is already destroyed!");
        }
    }

    protected final void addWaitKey(String name, W key, long timeoutMs) {
        if (timeoutMs > 0L) {
            long deadline = Clock.currentTimeMillis() + timeoutMs;
            this.waitTimeouts.putIfAbsent(BiTuple.of(name, ((WaitKey)key).invocationUid), BiTuple.of(timeoutMs, deadline));
        }
        if (timeoutMs != 0L) {
            this.addLiveOperation(key);
        }
    }

    protected final void removeWaitKey(String name, W key) {
        this.waitTimeouts.remove(BiTuple.of(name, ((WaitKey)key).invocationUid()));
        this.removeLiveOperation(key);
    }

    final void expireWaitKey(String name, UUID invocationUid, List<W> expired) {
        this.waitTimeouts.remove(BiTuple.of(name, invocationUid));
        R resource = this.getResourceOrNull(name);
        if (resource != null) {
            ((BlockingResource)resource).expireWaitKeys(invocationUid, expired);
        }
    }

    final Collection<BiTuple<String, UUID>> getWaitKeysToExpire(long now) {
        ArrayList<BiTuple<String, UUID>> expired = new ArrayList<BiTuple<String, UUID>>();
        for (Map.Entry e : this.waitTimeouts.entrySet()) {
            long deadline = (Long)((BiTuple)e.getValue()).element2;
            if (deadline > now) continue;
            expired.add((BiTuple<String, UUID>)e.getKey());
        }
        return expired;
    }

    final Map<BiTuple<String, UUID>, Long> overwriteWaitTimeouts(Map<BiTuple<String, UUID>, BiTuple<Long, Long>> existingWaitTimeouts) {
        for (Map.Entry<BiTuple<String, UUID>, BiTuple<Long, Long>> e : existingWaitTimeouts.entrySet()) {
            this.waitTimeouts.put(e.getKey(), e.getValue());
        }
        HashMap<BiTuple<String, UUID>, Long> newKeys = new HashMap<BiTuple<String, UUID>, Long>();
        for (Map.Entry e : this.waitTimeouts.entrySet()) {
            BiTuple key = (BiTuple)e.getKey();
            if (existingWaitTimeouts.containsKey(key)) continue;
            Long timeout = (Long)((BiTuple)e.getValue()).element1;
            newKeys.put(key, timeout);
        }
        return newKeys;
    }

    final void closeSession(long sessionId, List<Long> expiredWaitKeys, Map<Long, Object> result) {
        for (BlockingResource resource : this.resources.values()) {
            resource.closeSession(sessionId, expiredWaitKeys, result);
        }
    }

    final Collection<Long> getAttachedSessions() {
        HashSet<Long> sessions = new HashSet<Long>();
        for (BlockingResource res : this.resources.values()) {
            res.collectAttachedSessions(sessions);
        }
        return sessions;
    }

    final Collection<W> destroyResource(String name) {
        this.destroyedNames.add(name);
        BlockingResource resource = (BlockingResource)this.resources.remove(name);
        if (resource == null) {
            return null;
        }
        Collection keys = resource.getAllWaitKeys();
        for (WaitKey key : keys) {
            this.removeWaitKey(name, key);
        }
        return keys;
    }

    public final CPGroupId getGroupId() {
        return this.groupId;
    }

    public final Map<BiTuple<String, UUID>, BiTuple<Long, Long>> getWaitTimeouts() {
        return Collections.unmodifiableMap(this.waitTimeouts);
    }

    public final Collection<Long> destroy() {
        this.destroyedNames.addAll(this.resources.keySet());
        ArrayList<Long> indices = new ArrayList<Long>();
        for (BlockingResource raftLock : this.resources.values()) {
            for (WaitKey key : raftLock.getAllWaitKeys()) {
                indices.add(key.commitIndex());
            }
        }
        this.resources.clear();
        this.waitTimeouts.clear();
        return indices;
    }

    @Override
    public void populate(LiveOperations liveOperations) {
        for (BiTuple<Address, Long> t : this.liveOperationsSet) {
            liveOperations.add((Address)t.element1, (Long)t.element2);
        }
    }

    private void addLiveOperation(W key) {
        this.liveOperationsSet.add(BiTuple.of(((WaitKey)key).callerAddress(), ((WaitKey)key).callId()));
    }

    final void removeLiveOperation(W key) {
        this.liveOperationsSet.remove(BiTuple.of(((WaitKey)key).callerAddress(), ((WaitKey)key).callId()));
    }

    public final Collection<BiTuple<Address, Long>> getLiveOperations() {
        return this.liveOperationsSet;
    }

    final void onSnapshotRestore() {
        for (BlockingResource resource : this.resources.values()) {
            for (WaitKey key : resource.getAllWaitKeys()) {
                this.addLiveOperation(key);
            }
        }
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeObject(this.groupId);
        out.writeInt(this.resources.size());
        for (Map.Entry<String, R> entry : this.resources.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeObject(entry.getValue());
        }
        out.writeInt(this.destroyedNames.size());
        for (String string : this.destroyedNames) {
            out.writeUTF(string);
        }
        out.writeInt(this.waitTimeouts.size());
        for (Map.Entry entry : this.waitTimeouts.entrySet()) {
            BiTuple t = (BiTuple)entry.getKey();
            out.writeUTF((String)t.element1);
            UUIDSerializationUtil.writeUUID(out, (UUID)t.element2);
            out.writeLong((Long)((BiTuple)entry.getValue()).element1);
        }
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        String name;
        int i;
        this.groupId = (CPGroupId)in.readObject();
        int count = in.readInt();
        for (i = 0; i < count; ++i) {
            name = in.readUTF();
            BlockingResource res = (BlockingResource)in.readObject();
            this.resources.put(name, res);
        }
        count = in.readInt();
        for (i = 0; i < count; ++i) {
            name = in.readUTF();
            this.destroyedNames.add(name);
        }
        long now = Clock.currentTimeMillis();
        count = in.readInt();
        for (int i2 = 0; i2 < count; ++i2) {
            String name2 = in.readUTF();
            UUID invocationUid = UUIDSerializationUtil.readUUID(in);
            long timeout = in.readLong();
            this.waitTimeouts.put(BiTuple.of(name2, invocationUid), BiTuple.of(timeout, now + timeout));
        }
    }

    public String toString() {
        return "ResourceRegistry{groupId=" + this.groupId + ", resources=" + this.resources + ", destroyedNames=" + this.destroyedNames + ", waitTimeouts=" + this.waitTimeouts + '}';
    }
}

