/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.util;

import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.cluster.InitialMembershipEvent;
import com.hazelcast.cluster.InitialMembershipListener;
import com.hazelcast.cluster.Member;
import com.hazelcast.cluster.MemberAttributeEvent;
import com.hazelcast.cluster.MembershipEvent;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;

public abstract class AbstractLoadBalancer
implements LoadBalancer,
InitialMembershipListener {
    private final AtomicReference<Member[]> membersRef = new AtomicReference<Member[]>(new Member[0]);
    private volatile Cluster clusterRef;

    @Override
    public final void init(Cluster cluster, ClientConfig config) {
        this.clusterRef = cluster;
        cluster.addMembershipListener(this);
    }

    private void setMembersRef() {
        Set<Member> memberSet = this.clusterRef.getMembers();
        Member[] members = memberSet.toArray(new Member[0]);
        this.membersRef.set(members);
    }

    protected Member[] getMembers() {
        return this.membersRef.get();
    }

    @Override
    public final void init(InitialMembershipEvent event) {
        this.setMembersRef();
    }

    @Override
    public final void memberAdded(MembershipEvent membershipEvent) {
        this.setMembersRef();
    }

    @Override
    public final void memberRemoved(MembershipEvent membershipEvent) {
        this.setMembersRef();
    }

    @Override
    public final void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
    }
}

