/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi.impl;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.nio.ClientConnection;
import com.hazelcast.client.impl.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.cluster.Address;
import java.io.IOException;

public class NonSmartClientInvocationService
extends AbstractClientInvocationService {
    public NonSmartClientInvocationService(HazelcastClientInstanceImpl client) {
        super(client);
    }

    @Override
    public void invokeOnRandomTarget(ClientInvocation invocation) throws IOException {
        this.send(invocation, this.getConnection());
    }

    @Override
    public void invokeOnConnection(ClientInvocation invocation, ClientConnection connection) throws IOException {
        assert (connection != null);
        this.send(invocation, connection);
    }

    @Override
    public void invokeOnPartitionOwner(ClientInvocation invocation, int partitionId) throws IOException {
        invocation.getClientMessage().setPartitionId(partitionId);
        this.send(invocation, this.getConnection());
    }

    @Override
    public void invokeOnTarget(ClientInvocation invocation, Address target) throws IOException {
        this.send(invocation, this.getConnection());
    }

    private ClientConnection getConnection() throws IOException {
        ClientConnection connection = (ClientConnection)this.connectionManager.getRandomConnection();
        if (connection == null) {
            throw new IOException("NonSmartClientInvocationService: No connection is available.");
        }
        return connection;
    }
}

