/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.spi;

import com.hazelcast.client.cache.impl.nearcache.invalidation.ClientCacheInvalidationMetaDataFetcher;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientExecutionService;
import com.hazelcast.client.impl.spi.ClientInvocationService;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.ClientTransactionManagerService;
import com.hazelcast.client.impl.spi.ProxyManager;
import com.hazelcast.client.map.impl.nearcache.invalidation.ClientMapInvalidationMetaDataFetcher;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.nearcache.impl.invalidation.InvalidationMetaDataFetcher;
import com.hazelcast.internal.nearcache.impl.invalidation.MinimalPartitionService;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingTask;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ConcurrencyUtil;
import com.hazelcast.internal.util.ConstructorFunction;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.properties.HazelcastProperties;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ClientContext {
    private final InternalSerializationService serializationService;
    private final ClientClusterService clusterService;
    private final ClientPartitionService partitionService;
    private final ClientInvocationService invocationService;
    private final ClientExecutionService executionService;
    private final ClientListenerService listenerService;
    private final ClientConnectionManager clientConnectionManager;
    private final LifecycleService lifecycleService;
    private final ClientTransactionManagerService transactionManager;
    private final ProxyManager proxyManager;
    private final ClientConfig clientConfig;
    private final LoggingService loggingService;
    private final HazelcastProperties properties;
    private final Map<String, NearCacheManager> nearCacheManagers;
    private final MinimalPartitionService minimalPartitionService;
    private final ClientQueryCacheContext queryCacheContext;
    private final ConcurrentMap<String, RepairingTask> repairingTasks = new ConcurrentHashMap<String, RepairingTask>();
    private final ConstructorFunction<String, RepairingTask> repairingTaskConstructor = this::newRepairingTask;
    private final String name;

    public ClientContext(HazelcastClientInstanceImpl client) {
        this.name = client.getName();
        this.serializationService = client.getSerializationService();
        this.clusterService = client.getClientClusterService();
        this.partitionService = client.getClientPartitionService();
        this.invocationService = client.getInvocationService();
        this.executionService = client.getClientExecutionService();
        this.listenerService = client.getListenerService();
        this.clientConnectionManager = client.getConnectionManager();
        this.lifecycleService = client.getLifecycleService();
        this.proxyManager = client.getProxyManager();
        this.clientConfig = client.getClientConfig();
        this.transactionManager = client.getTransactionManager();
        this.loggingService = client.getLoggingService();
        this.nearCacheManagers = client.getNearCacheManagers();
        this.properties = client.getProperties();
        this.minimalPartitionService = new ClientMinimalPartitionService();
        this.queryCacheContext = client.getQueryCacheContext();
    }

    public ClientQueryCacheContext getQueryCacheContext() {
        return this.queryCacheContext;
    }

    public RepairingTask getRepairingTask(String serviceName) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.repairingTasks, serviceName, this.repairingTaskConstructor);
    }

    private RepairingTask newRepairingTask(String serviceName) {
        InvalidationMetaDataFetcher invalidationMetaDataFetcher = this.newMetaDataFetcher(serviceName);
        ILogger logger = this.loggingService.getLogger(RepairingTask.class);
        return new RepairingTask(this.properties, invalidationMetaDataFetcher, this.executionService, this.serializationService, this.minimalPartitionService, this.clientConnectionManager.getClientUuid(), logger);
    }

    private InvalidationMetaDataFetcher newMetaDataFetcher(String serviceName) {
        if ("hz:impl:mapService".equals(serviceName)) {
            return new ClientMapInvalidationMetaDataFetcher(this);
        }
        if ("hz:impl:cacheService".equals(serviceName)) {
            return new ClientCacheInvalidationMetaDataFetcher(this);
        }
        throw new IllegalArgumentException(String.format("%s is not a known service-name to fetch metadata for", serviceName));
    }

    public String getName() {
        return this.name;
    }

    public HazelcastInstance getHazelcastInstance() {
        return this.proxyManager.getHazelcastInstance();
    }

    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientClusterService getClusterService() {
        return this.clusterService;
    }

    public ClientPartitionService getPartitionService() {
        return this.partitionService;
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    public ClientExecutionService getExecutionService() {
        return this.executionService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public NearCacheManager getNearCacheManager(String serviceName) {
        return this.nearCacheManagers.get(serviceName);
    }

    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.clientConnectionManager;
    }

    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public ClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public boolean isActive() {
        return this.getHazelcastInstance().getLifecycleService().isRunning();
    }

    private class ClientMinimalPartitionService
    implements MinimalPartitionService {
        private ClientMinimalPartitionService() {
        }

        @Override
        public int getPartitionId(Data key) {
            return ClientContext.this.partitionService.getPartitionId(key);
        }

        @Override
        public int getPartitionId(Object key) {
            return ClientContext.this.partitionService.getPartitionId(key);
        }

        @Override
        public int getPartitionCount() {
            return ClientContext.this.partitionService.getPartitionCount();
        }
    }
}

