/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.querycache;

import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.querycache.subscriber.ClientInvokerWrapper;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheConfigurator;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheEventService;
import com.hazelcast.client.impl.querycache.subscriber.ClientQueryCacheScheduler;
import com.hazelcast.client.impl.querycache.subscriber.ClientSubscriberContext;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ContextMutexFactory;
import com.hazelcast.map.impl.querycache.InvokerWrapper;
import com.hazelcast.map.impl.querycache.QueryCacheConfigurator;
import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.QueryCacheEventService;
import com.hazelcast.map.impl.querycache.QueryCacheScheduler;
import com.hazelcast.map.impl.querycache.accumulator.Accumulator;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.publisher.PublisherContext;
import com.hazelcast.map.impl.querycache.subscriber.InternalQueryCache;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheFactory;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberRegistry;
import java.util.Collection;
import java.util.Map;

public class ClientQueryCacheContext
implements QueryCacheContext {
    private final HazelcastClientInstanceImpl client;
    private final InvokerWrapper invokerWrapper;
    private final QueryCacheScheduler queryCacheScheduler;
    private final QueryCacheEventService queryCacheEventService;
    private final QueryCacheConfigurator queryCacheConfigurator;
    private final ContextMutexFactory mutexFactory = new ContextMutexFactory();
    private SubscriberContext subscriberContext;

    public ClientQueryCacheContext(HazelcastClientInstanceImpl client) {
        this.client = client;
        this.queryCacheEventService = new ClientQueryCacheEventService(client);
        this.queryCacheConfigurator = new ClientQueryCacheConfigurator(client.getClientConfig(), this.queryCacheEventService);
        this.queryCacheScheduler = new ClientQueryCacheScheduler(client.getClientExecutionService());
        this.invokerWrapper = new ClientInvokerWrapper(this, client);
        this.subscriberContext = new ClientSubscriberContext(this);
    }

    @Override
    public SubscriberContext getSubscriberContext() {
        return this.subscriberContext;
    }

    @Override
    public Object toObject(Object obj) {
        InternalSerializationService serializationService = this.client.getSerializationService();
        return serializationService.toObject(obj);
    }

    @Override
    public void destroy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.client.getSerializationService();
    }

    @Override
    public Collection<Member> getMemberList() {
        return this.client.getClientClusterService().getMemberList();
    }

    @Override
    public int getPartitionId(Object object) {
        return this.client.getClientPartitionService().getPartitionId(object);
    }

    @Override
    public int getPartitionCount() {
        return this.client.getClientPartitionService().getPartitionCount();
    }

    @Override
    public ContextMutexFactory getLifecycleMutexFactory() {
        return this.mutexFactory;
    }

    @Override
    public InvokerWrapper getInvokerWrapper() {
        return this.invokerWrapper;
    }

    @Override
    public QueryCacheEventService getQueryCacheEventService() {
        return this.queryCacheEventService;
    }

    @Override
    public QueryCacheConfigurator getQueryCacheConfigurator() {
        return this.queryCacheConfigurator;
    }

    @Override
    public QueryCacheScheduler getQueryCacheScheduler() {
        return this.queryCacheScheduler;
    }

    @Override
    public void setSubscriberContext(SubscriberContext subscriberContext) {
        this.subscriberContext = subscriberContext;
    }

    @Override
    public PublisherContext getPublisherContext() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Address getThisNodesAddress() {
        throw new UnsupportedOperationException();
    }

    public void recreateAllCaches() {
        QueryCacheFactory queryCacheFactory = this.subscriberContext.getQueryCacheFactory();
        Map<String, SubscriberRegistry> registryMap = this.subscriberContext.getMapSubscriberRegistry().getAll();
        for (SubscriberRegistry subscriberRegistry : registryMap.values()) {
            Map<String, Accumulator> accumulatorMap = subscriberRegistry.getAll();
            for (Accumulator accumulator : accumulatorMap.values()) {
                AccumulatorInfo info = accumulator.getInfo();
                String cacheId = info.getCacheId();
                InternalQueryCache queryCache = queryCacheFactory.getOrNull(cacheId);
                if (queryCache == null) continue;
                queryCache.recreate();
            }
        }
    }
}

