/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.client.config.ClientReliableTopicConfig;
import com.hazelcast.client.impl.clientside.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.proxy.ClientReliableMessageRunner;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientProxy;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.topic.ITopic;
import com.hazelcast.topic.LocalTopicStats;
import com.hazelcast.topic.MessageListener;
import com.hazelcast.topic.ReliableMessageListener;
import com.hazelcast.topic.TopicOverloadException;
import com.hazelcast.topic.TopicOverloadPolicy;
import com.hazelcast.topic.impl.reliable.MessageRunner;
import com.hazelcast.topic.impl.reliable.ReliableMessageListenerAdapter;
import com.hazelcast.topic.impl.reliable.ReliableTopicMessage;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class ClientReliableTopicProxy<E>
extends ClientProxy
implements ITopic<E> {
    private static final String NULL_MESSAGE_IS_NOT_ALLOWED = "Null message is not allowed!";
    private static final String NULL_LISTENER_IS_NOT_ALLOWED = "Null listener is not allowed!";
    private static final int MAX_BACKOFF = 2000;
    private static final int INITIAL_BACKOFF_MS = 100;
    private final ILogger logger;
    private final ConcurrentMap<UUID, MessageRunner<E>> runnersMap = new ConcurrentHashMap<UUID, MessageRunner<E>>();
    private final Ringbuffer<ReliableTopicMessage> ringbuffer;
    private final SerializationService serializationService;
    private final ClientReliableTopicConfig config;
    private final Executor executor;
    private final TopicOverloadPolicy overloadPolicy;

    public ClientReliableTopicProxy(String objectId, ClientContext context, HazelcastClientInstanceImpl client) {
        super("hz:impl:reliableTopicService", objectId, context);
        this.ringbuffer = client.getRingbuffer("_hz_rb_" + objectId);
        this.serializationService = client.getSerializationService();
        this.config = client.getClientConfig().getReliableTopicConfig(objectId);
        this.executor = this.getExecutor(this.config, client);
        this.overloadPolicy = this.config.getTopicOverloadPolicy();
        this.logger = client.getLoggingService().getLogger(this.getClass());
    }

    private Executor getExecutor(ClientReliableTopicConfig config, HazelcastClientInstanceImpl client) {
        Executor executor = config.getExecutor();
        if (executor == null) {
            executor = client.getClientExecutionService().getUserExecutor();
        }
        return executor;
    }

    @Override
    public void publish(@Nonnull E payload) {
        Preconditions.checkNotNull(payload, NULL_MESSAGE_IS_NOT_ALLOWED);
        try {
            Object data = this.serializationService.toData(payload);
            ReliableTopicMessage message = new ReliableTopicMessage((Data)data, null);
            switch (this.overloadPolicy) {
                case ERROR: {
                    this.addOrFail(message);
                    break;
                }
                case DISCARD_OLDEST: {
                    this.addOrOverwrite(message);
                    break;
                }
                case DISCARD_NEWEST: {
                    this.ringbuffer.addAsync(message, OverflowPolicy.FAIL).toCompletableFuture().get();
                    break;
                }
                case BLOCK: {
                    this.addWithBackoff(message);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown overloadPolicy:" + (Object)((Object)this.overloadPolicy));
                }
            }
        }
        catch (Exception e) {
            throw (RuntimeException)ExceptionUtil.peel(e, null, "Failed to publish message: " + payload + " to topic:" + this.getName());
        }
    }

    private void addOrOverwrite(ReliableTopicMessage message) throws Exception {
        this.ringbuffer.addAsync(message, OverflowPolicy.OVERWRITE).toCompletableFuture().get();
    }

    private void addOrFail(ReliableTopicMessage message) throws Exception {
        long sequenceId = this.ringbuffer.addAsync(message, OverflowPolicy.FAIL).toCompletableFuture().get();
        if (sequenceId == -1L) {
            throw new TopicOverloadException("Failed to publish message: " + message + " on topic:" + this.name);
        }
    }

    private void addWithBackoff(ReliableTopicMessage message) throws Exception {
        long result;
        long timeoutMs = 100L;
        while ((result = this.ringbuffer.addAsync(message, OverflowPolicy.FAIL).toCompletableFuture().get().longValue()) == -1L) {
            TimeUnit.MILLISECONDS.sleep(timeoutMs);
            if ((timeoutMs *= 2L) <= 2000L) continue;
            timeoutMs = 2000L;
        }
    }

    @Override
    @Nonnull
    public UUID addMessageListener(@Nonnull MessageListener<E> listener) {
        Preconditions.checkNotNull(listener, NULL_LISTENER_IS_NOT_ALLOWED);
        UUID id = UuidUtil.newUnsecureUUID();
        ReliableMessageListener<E> reliableMessageListener = this.toReliableMessageListener(listener);
        ClientReliableMessageRunner<E> runner = new ClientReliableMessageRunner<E>(id, reliableMessageListener, this.ringbuffer, this.name, this.config.getReadBatchSize(), this.serializationService, this.executor, this.runnersMap, this.logger);
        this.runnersMap.put(id, runner);
        runner.next();
        return id;
    }

    public boolean isListenerCancelled(UUID registrationID) {
        Preconditions.checkNotNull(registrationID, "registrationId can't be null");
        MessageRunner runner = (MessageRunner)this.runnersMap.get(registrationID);
        if (runner == null) {
            return true;
        }
        return runner.isCancelled();
    }

    private ReliableMessageListener<E> toReliableMessageListener(MessageListener<E> listener) {
        if (listener instanceof ReliableMessageListener) {
            return (ReliableMessageListener)listener;
        }
        return new ReliableMessageListenerAdapter<E>(listener);
    }

    @Override
    public boolean removeMessageListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "registrationId can't be null");
        MessageRunner runner = (MessageRunner)this.runnersMap.get(registrationId);
        if (runner == null) {
            return false;
        }
        runner.cancel();
        return true;
    }

    @Override
    @Nonnull
    public LocalTopicStats getLocalTopicStats() {
        throw new UnsupportedOperationException("Locality is ambiguous for client!");
    }

    public Ringbuffer getRingbuffer() {
        return this.ringbuffer;
    }

    public String toString() {
        return "ITopic{name='" + this.name + '\'' + '}';
    }

    @Override
    protected void postDestroy() {
        this.ringbuffer.destroy();
    }
}

