/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.proxy;

import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.impl.clientside.ClientMessageDecoder;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CardinalityEstimatorAddCodec;
import com.hazelcast.client.impl.protocol.codec.CardinalityEstimatorEstimateCodec;
import com.hazelcast.client.impl.proxy.PartitionSpecificClientProxy;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import javax.annotation.Nonnull;

public class ClientCardinalityEstimatorProxy
extends PartitionSpecificClientProxy
implements CardinalityEstimator {
    private static final ClientMessageDecoder ADD_DECODER = new ClientMessageDecoder(){

        public Void decodeClientMessage(ClientMessage clientMessage) {
            return null;
        }
    };
    private static final ClientMessageDecoder ESTIMATE_DECODER = new ClientMessageDecoder(){

        public Long decodeClientMessage(ClientMessage clientMessage) {
            return CardinalityEstimatorEstimateCodec.decodeResponse((ClientMessage)clientMessage).response;
        }
    };

    public ClientCardinalityEstimatorProxy(String serviceName, String objectId, ClientContext context) {
        super(serviceName, objectId, context);
    }

    public String toString() {
        return "CardinalityEstimator{name='" + this.name + '\'' + '}';
    }

    @Override
    public void add(@Nonnull Object obj) {
        ((InternalCompletableFuture)this.addAsync(obj)).joinInternal();
    }

    @Override
    public long estimate() {
        return (Long)((InternalCompletableFuture)this.estimateAsync()).joinInternal();
    }

    public InternalCompletableFuture<Void> addAsync(@Nonnull Object obj) {
        Preconditions.checkNotNull(obj, "Object must not be null");
        Data data = this.toData(obj);
        ClientMessage request = CardinalityEstimatorAddCodec.encodeRequest(this.name, data.hash64());
        return this.invokeOnPartitionAsync(request, ADD_DECODER);
    }

    public InternalCompletableFuture<Long> estimateAsync() {
        ClientMessage request = CardinalityEstimatorEstimateCodec.encodeRequest(this.name);
        return this.invokeOnPartitionAsync(request, ESTIMATE_DECODER);
    }
}

