/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.replicatedmap;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.task.AbstractAddListenerMessageTask;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.EntryEvent;
import com.hazelcast.core.EntryListener;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.map.IMapEvent;
import com.hazelcast.map.MapEvent;
import com.hazelcast.map.impl.DataAwareEntryEvent;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.replicatedmap.impl.ReplicatedMapEventPublishingService;
import com.hazelcast.replicatedmap.impl.ReplicatedMapService;
import com.hazelcast.replicatedmap.impl.record.ReplicatedEntryEventFilter;
import com.hazelcast.replicatedmap.impl.record.ReplicatedQueryEventFilter;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public abstract class AbstractReplicatedMapAddEntryListenerMessageTask<Parameter>
extends AbstractAddListenerMessageTask<Parameter>
implements EntryListener<Object, Object> {
    public AbstractReplicatedMapAddEntryListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        ReplicatedMapService service = (ReplicatedMapService)this.getService("hz:impl:replicatedMapService");
        ReplicatedMapEventPublishingService eventPublishingService = service.getEventPublishingService();
        Predicate predicate = this.getPredicate();
        ReplicatedEntryEventFilter filter = predicate == null ? new ReplicatedEntryEventFilter(this.getKey()) : new ReplicatedQueryEventFilter(this.getKey(), predicate);
        return InternalCompletableFuture.newCompletedFuture(eventPublishingService.addLocalEventListener(this, filter, this.getDistributedObjectName()));
    }

    @Override
    public String getServiceName() {
        return "hz:impl:replicatedMapService";
    }

    @Override
    public String getMethodName() {
        return "addEntryListener";
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.getDistributedObjectName(), "listen");
    }

    public abstract Predicate getPredicate();

    public abstract Data getKey();

    protected abstract boolean isLocalOnly();

    private void handleEvent(EntryEvent<Object, Object> event) {
        if (!this.shouldSendEvent(event)) {
            return;
        }
        DataAwareEntryEvent dataAwareEntryEvent = (DataAwareEntryEvent)event;
        Data key = dataAwareEntryEvent.getKeyData();
        Data newValue = dataAwareEntryEvent.getNewValueData();
        Data oldValue = dataAwareEntryEvent.getOldValueData();
        Data mergingValue = dataAwareEntryEvent.getMergingValueData();
        ClientMessage clientMessage = this.encodeEvent(key, newValue, oldValue, mergingValue, event.getEventType().getType(), event.getMember().getUuid(), 1);
        this.sendClientMessage(key, clientMessage);
    }

    private void handleMapEvent(MapEvent event) {
        if (!this.shouldSendEvent(event)) {
            return;
        }
        ClientMessage clientMessage = this.encodeEvent(null, null, null, null, event.getEventType().getType(), event.getMember().getUuid(), event.getNumberOfEntriesAffected());
        this.sendClientMessage(null, clientMessage);
    }

    private boolean shouldSendEvent(IMapEvent event) {
        if (!this.endpoint.isAlive()) {
            return false;
        }
        Member originatedMember = event.getMember();
        return !this.isLocalOnly() || this.nodeEngine.getLocalMember().equals(originatedMember);
    }

    protected abstract ClientMessage encodeEvent(Data var1, Data var2, Data var3, Data var4, int var5, UUID var6, int var7);

    @Override
    public void entryAdded(EntryEvent<Object, Object> event) {
        this.handleEvent(event);
    }

    @Override
    public void entryRemoved(EntryEvent<Object, Object> event) {
        this.handleEvent(event);
    }

    @Override
    public void entryUpdated(EntryEvent<Object, Object> event) {
        this.handleEvent(event);
    }

    @Override
    public void entryEvicted(EntryEvent<Object, Object> event) {
        this.handleEvent(event);
    }

    @Override
    public void entryExpired(EntryEvent<Object, Object> event) {
        this.handleEvent(event);
    }

    @Override
    public void mapEvicted(MapEvent event) {
        this.handleMapEvent(event);
    }

    @Override
    public void mapCleared(MapEvent event) {
        this.handleMapEvent(event);
    }
}

