/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddPartitionLostListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractAddListenerMessageTask;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.partition.PartitionLostListener;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.security.Permission;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;

public class AddPartitionLostListenerMessageTask
extends AbstractAddListenerMessageTask<ClientAddPartitionLostListenerCodec.RequestParameters> {
    public AddPartitionLostListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected CompletableFuture<UUID> processInternal() {
        IPartitionService partitionService = (IPartitionService)this.getService(this.getServiceName());
        PartitionLostListener listener = event -> {
            if (this.endpoint.isAlive()) {
                ClientMessage eventMessage = ClientAddPartitionLostListenerCodec.encodePartitionLostEvent(event.getPartitionId(), event.getLostBackupCount(), event.getEventSource());
                this.sendClientMessage(null, eventMessage);
            }
        };
        if (((ClientAddPartitionLostListenerCodec.RequestParameters)this.parameters).localOnly) {
            return InternalCompletableFuture.newCompletedFuture(partitionService.addLocalPartitionLostListener(listener));
        }
        return partitionService.addPartitionLostListenerAsync(listener);
    }

    @Override
    protected ClientAddPartitionLostListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ClientAddPartitionLostListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ClientAddPartitionLostListenerCodec.encodeResponse((UUID)response);
    }

    @Override
    public String getServiceName() {
        return "hz:core:partitionService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public String getDistributedObjectName() {
        return ".partitionLost";
    }

    @Override
    public String getMethodName() {
        return "addPartitionLostListener";
    }

    @Override
    public Object[] getParameters() {
        return null;
    }
}

