/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task;

import com.hazelcast.client.impl.ClientClusterListenerService;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientAddClusterViewListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.MemberAttributeEvent;
import com.hazelcast.cluster.MemberAttributeOperationType;
import com.hazelcast.cluster.MembershipEvent;
import com.hazelcast.cluster.MembershipListener;
import com.hazelcast.cluster.impl.MemberImpl;
import com.hazelcast.instance.EndpointQualifier;
import com.hazelcast.instance.impl.Node;
import com.hazelcast.internal.cluster.impl.ClusterServiceImpl;
import com.hazelcast.internal.nio.Connection;
import com.hazelcast.internal.partition.InternalPartitionService;
import com.hazelcast.internal.util.UuidUtil;
import java.security.Permission;
import java.util.UUID;

public class AddClusterViewListenerMessageTask
extends AbstractCallableMessageTask<ClientAddClusterViewListenerCodec.RequestParameters>
implements MembershipListener {
    private boolean advancedNetworkConfigEnabled = this.isAdvancedNetworkEnabled();

    public AddClusterViewListenerMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        ClientClusterListenerService service = this.clientEngine.getClientClusterListenerService();
        service.registerListener(this.endpoint, this.clientMessage.getCorrelationId());
        this.endpoint.addDestroyAction(UuidUtil.newUnsecureUUID(), () -> {
            service.deregisterListener(this.endpoint);
            return Boolean.TRUE;
        });
        String serviceName = "hz:core:clusterService";
        ClusterServiceImpl clusterService = (ClusterServiceImpl)this.getService(serviceName);
        UUID registrationId = clusterService.addMembershipListener(this);
        this.endpoint.addListenerDestroyAction(serviceName, serviceName, registrationId);
        InternalPartitionService internalPartitionService = (InternalPartitionService)this.getService("hz:core:partitionService");
        internalPartitionService.firstArrangement();
        return true;
    }

    @Override
    protected ClientAddClusterViewListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ClientAddClusterViewListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return ClientAddClusterViewListenerCodec.encodeResponse();
    }

    @Override
    public String getServiceName() {
        return "hz:core:clusterService";
    }

    @Override
    public String getDistributedObjectName() {
        return null;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public void memberAdded(MembershipEvent membershipEvent) {
    }

    @Override
    public void memberRemoved(MembershipEvent membershipEvent) {
    }

    @Override
    public void memberAttributeChanged(MemberAttributeEvent memberAttributeEvent) {
        if (!this.endpoint.isAlive()) {
            return;
        }
        MemberAttributeOperationType op = memberAttributeEvent.getOperationType();
        String key = memberAttributeEvent.getKey();
        String value = memberAttributeEvent.getValue() == null ? null : memberAttributeEvent.getValue().toString();
        MemberImpl member = (MemberImpl)memberAttributeEvent.getMember();
        ClientMessage eventMessage = ClientAddClusterViewListenerCodec.encodeMemberAttributeChangeEvent(this.translateMemberAddress(member), key, op.getId(), value);
        this.sendClientMessage(eventMessage);
    }

    private MemberImpl translateMemberAddress(MemberImpl member) {
        if (!this.advancedNetworkConfigEnabled) {
            return member;
        }
        Address clientAddress = member.getAddressMap().get(EndpointQualifier.CLIENT);
        MemberImpl result = new MemberImpl.Builder(clientAddress).version(member.getVersion()).uuid(member.getUuid()).localMember(member.localMember()).liteMember(member.isLiteMember()).memberListJoinVersion(member.getMemberListJoinVersion()).attributes(member.getAttributes()).build();
        return result;
    }
}

