/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec.custom;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerImpl;

public final class ScheduledTaskHandlerCodec {
    private static final int PARTITION_ID_FIELD_OFFSET = 0;
    private static final int INITIAL_FRAME_SIZE = 4;

    private ScheduledTaskHandlerCodec() {
    }

    public static void encode(ClientMessage clientMessage, ScheduledTaskHandler scheduledTaskHandler) {
        clientMessage.add(ClientMessage.BEGIN_FRAME.copy());
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[4]);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, scheduledTaskHandler.getPartitionId());
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, scheduledTaskHandler.getAddress(), AddressCodec::encode);
        StringCodec.encode(clientMessage, scheduledTaskHandler.getSchedulerName());
        StringCodec.encode(clientMessage, scheduledTaskHandler.getTaskName());
        clientMessage.add(ClientMessage.END_FRAME.copy());
    }

    public static ScheduledTaskHandlerImpl decode(ClientMessage.ForwardFrameIterator iterator) {
        iterator.next();
        ClientMessage.Frame initialFrame = iterator.next();
        int partitionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 0);
        Address address = CodecUtil.decodeNullable(iterator, AddressCodec::decode);
        String schedulerName = StringCodec.decode(iterator);
        String taskName = StringCodec.decode(iterator);
        CodecUtil.fastForwardToEndFrame(iterator);
        return new ScheduledTaskHandlerImpl(address, partitionId, schedulerName, taskName);
    }
}

