/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;

public final class MapFetchEntriesCodec {
    public static final int REQUEST_MESSAGE_TYPE = 80128;
    public static final int RESPONSE_MESSAGE_TYPE = 80129;
    private static final int REQUEST_TABLE_INDEX_FIELD_OFFSET = 16;
    private static final int REQUEST_BATCH_FIELD_OFFSET = 20;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 24;
    private static final int RESPONSE_TABLE_INDEX_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 20;

    private MapFetchEntriesCodec() {
    }

    public static ClientMessage encodeRequest(String name, int tableIndex, int batch) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("Map.FetchEntries");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 80128);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, tableIndex);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, batch);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.tableIndex = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.batch = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(int tableIndex, Collection<Map.Entry<Data, Data>> entries) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 80129);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, tableIndex);
        clientMessage.add(initialFrame);
        EntryListCodec.encode(clientMessage, entries, DataCodec::encode, DataCodec::encode);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.tableIndex = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        response.entries = EntryListCodec.decode(iterator, DataCodec::decode, DataCodec::decode);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public int tableIndex;
        public List<Map.Entry<Data, Data>> entries;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int tableIndex;
        public int batch;
    }
}

