/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListLongCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListUUIDCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;

public final class MapAddNearCacheEntryListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 72192;
    public static final int RESPONSE_MESSAGE_TYPE = 72193;
    private static final int REQUEST_LISTENER_FLAGS_FIELD_OFFSET = 16;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 20;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 21;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 33;
    private static final int EVENT_I_MAP_INVALIDATION_SOURCE_UUID_FIELD_OFFSET = 16;
    private static final int EVENT_I_MAP_INVALIDATION_PARTITION_UUID_FIELD_OFFSET = 33;
    private static final int EVENT_I_MAP_INVALIDATION_SEQUENCE_FIELD_OFFSET = 50;
    private static final int EVENT_I_MAP_INVALIDATION_INITIAL_FRAME_SIZE = 58;
    private static final int EVENT_I_MAP_INVALIDATION_MESSAGE_TYPE = 72194;
    private static final int EVENT_I_MAP_BATCH_INVALIDATION_INITIAL_FRAME_SIZE = 16;
    private static final int EVENT_I_MAP_BATCH_INVALIDATION_MESSAGE_TYPE = 72195;

    private MapAddNearCacheEntryListenerCodec() {
    }

    public static ClientMessage encodeRequest(String name, int listenerFlags, boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Map.AddNearCacheEntryListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 72192);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, listenerFlags);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 20, localOnly);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.listenerFlags = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 20);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 72193);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        return response;
    }

    public static ClientMessage encodeIMapInvalidationEvent(@Nullable Data key, UUID sourceUuid, UUID partitionUuid, long sequence) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[58], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 72194);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, sourceUuid);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 33, partitionUuid);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 50, sequence);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, key, DataCodec::encode);
        return clientMessage;
    }

    public static ClientMessage encodeIMapBatchInvalidationEvent(Collection<Data> keys, Collection<UUID> sourceUuids, Collection<UUID> partitionUuids, Collection<Long> sequences) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 72195);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, keys, DataCodec::encode);
        ListUUIDCodec.encode(clientMessage, sourceUuids);
        ListUUIDCodec.encode(clientMessage, partitionUuids);
        ListLongCodec.encode(clientMessage, sequences);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 72194) {
                ClientMessage.Frame initialFrame = iterator.next();
                UUID sourceUuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
                UUID partitionUuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 33);
                long sequence = FixedSizeTypesCodec.decodeLong(initialFrame.content, 50);
                Data key = CodecUtil.decodeNullable(iterator, DataCodec::decode);
                this.handleIMapInvalidationEvent(key, sourceUuid, partitionUuid, sequence);
                return;
            }
            if (messageType == 72195) {
                iterator.next();
                List<Data> keys = ListMultiFrameCodec.decode(iterator, DataCodec::decode);
                List<UUID> sourceUuids = ListUUIDCodec.decode(iterator);
                List<UUID> partitionUuids = ListUUIDCodec.decode(iterator);
                List<Long> sequences = ListLongCodec.decode(iterator);
                this.handleIMapBatchInvalidationEvent(keys, sourceUuids, partitionUuids, sequences);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleIMapInvalidationEvent(@Nullable Data var1, UUID var2, UUID var3, long var4);

        public abstract void handleIMapBatchInvalidationEvent(Collection<Data> var1, Collection<UUID> var2, Collection<UUID> var3, Collection<Long> var4);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public UUID response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int listenerFlags;
        public boolean localOnly;
    }
}

