/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.DataCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.serialization.Data;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nullable;

public final class MapAddEntryListenerToKeyCodec {
    public static final int REQUEST_MESSAGE_TYPE = 71680;
    public static final int RESPONSE_MESSAGE_TYPE = 71681;
    private static final int REQUEST_INCLUDE_VALUE_FIELD_OFFSET = 16;
    private static final int REQUEST_LISTENER_FLAGS_FIELD_OFFSET = 17;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 21;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 22;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 33;
    private static final int EVENT_ENTRY_EVENT_TYPE_FIELD_OFFSET = 16;
    private static final int EVENT_ENTRY_UUID_FIELD_OFFSET = 20;
    private static final int EVENT_ENTRY_NUMBER_OF_AFFECTED_ENTRIES_FIELD_OFFSET = 37;
    private static final int EVENT_ENTRY_INITIAL_FRAME_SIZE = 41;
    private static final int EVENT_ENTRY_MESSAGE_TYPE = 71682;

    private MapAddEntryListenerToKeyCodec() {
    }

    public static ClientMessage encodeRequest(String name, Data key, boolean includeValue, int listenerFlags, boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Map.AddEntryListenerToKey");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[22], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 71680);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, includeValue);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 17, listenerFlags);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 21, localOnly);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        DataCodec.encode(clientMessage, key);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.includeValue = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        request.listenerFlags = FixedSizeTypesCodec.decodeInt(initialFrame.content, 17);
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 21);
        request.name = StringCodec.decode(iterator);
        request.key = DataCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 71681);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        return response;
    }

    public static ClientMessage encodeEntryEvent(@Nullable Data key, @Nullable Data value, @Nullable Data oldValue, @Nullable Data mergingValue, int eventType, UUID uuid, int numberOfAffectedEntries) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[41], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 71682);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, eventType);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 20, uuid);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 37, numberOfAffectedEntries);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, key, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, value, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, oldValue, DataCodec::encode);
        CodecUtil.encodeNullable(clientMessage, mergingValue, DataCodec::encode);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 71682) {
                ClientMessage.Frame initialFrame = iterator.next();
                int eventType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                UUID uuid = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 20);
                int numberOfAffectedEntries = FixedSizeTypesCodec.decodeInt(initialFrame.content, 37);
                Data key = CodecUtil.decodeNullable(iterator, DataCodec::decode);
                Data value = CodecUtil.decodeNullable(iterator, DataCodec::decode);
                Data oldValue = CodecUtil.decodeNullable(iterator, DataCodec::decode);
                Data mergingValue = CodecUtil.decodeNullable(iterator, DataCodec::decode);
                this.handleEntryEvent(key, value, oldValue, mergingValue, eventType, uuid, numberOfAffectedEntries);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleEntryEvent(@Nullable Data var1, @Nullable Data var2, @Nullable Data var3, @Nullable Data var4, int var5, UUID var6, int var7);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public UUID response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public Data key;
        public boolean includeValue;
        public int listenerFlags;
        public boolean localOnly;
    }
}

