/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.ClientBwListEntryCodec;
import com.hazelcast.internal.management.dto.ClientBwListEntryDTO;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import javax.annotation.Nullable;

public final class MCApplyMCConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x200D00;
    public static final int RESPONSE_MESSAGE_TYPE = 2100481;
    private static final int REQUEST_CLIENT_BW_LIST_MODE_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 20;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private MCApplyMCConfigCodec() {
    }

    public static ClientMessage encodeRequest(String eTag, int clientBwListMode, @Nullable List<ClientBwListEntryDTO> clientBwListEntries) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("MC.ApplyMCConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x200D00);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, clientBwListMode);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, eTag);
        ListMultiFrameCodec.encodeNullable(clientMessage, clientBwListEntries, ClientBwListEntryCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.clientBwListMode = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.eTag = StringCodec.decode(iterator);
        request.clientBwListEntries = ListMultiFrameCodec.decodeNullable(iterator, ClientBwListEntryCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 2100481);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String eTag;
        public int clientBwListMode;
        @Nullable
        public List<ClientBwListEntryDTO> clientBwListEntries;
    }
}

