/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;

public final class FlakeIdGeneratorNewIdBatchCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x1C0100;
    public static final int RESPONSE_MESSAGE_TYPE = 0x1C0101;
    private static final int REQUEST_BATCH_SIZE_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 20;
    private static final int RESPONSE_BASE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INCREMENT_FIELD_OFFSET = 24;
    private static final int RESPONSE_BATCH_SIZE_FIELD_OFFSET = 32;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 36;

    private FlakeIdGeneratorNewIdBatchCodec() {
    }

    public static ClientMessage encodeRequest(String name, int batchSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(true);
        clientMessage.setOperationName("FlakeIdGenerator.NewIdBatch");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1C0100);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, batchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.batchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.name = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse(long base, long increment, int batchSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[36], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1C0101);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 16, base);
        FixedSizeTypesCodec.encodeLong(initialFrame.content, 24, increment);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 32, batchSize);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.base = FixedSizeTypesCodec.decodeLong(initialFrame.content, 16);
        response.increment = FixedSizeTypesCodec.decodeLong(initialFrame.content, 24);
        response.batchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 32);
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public long base;
        public long increment;
        public int batchSize;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int batchSize;
    }
}

