/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class DynamicConfigAddScheduledExecutorConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1772032;
    public static final int RESPONSE_MESSAGE_TYPE = 1772033;
    private static final int REQUEST_POOL_SIZE_FIELD_OFFSET = 16;
    private static final int REQUEST_DURABILITY_FIELD_OFFSET = 20;
    private static final int REQUEST_CAPACITY_FIELD_OFFSET = 24;
    private static final int REQUEST_MERGE_BATCH_SIZE_FIELD_OFFSET = 28;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 32;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private DynamicConfigAddScheduledExecutorConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, int poolSize, int durability, int capacity, @Nullable String splitBrainProtectionName, String mergePolicy, int mergeBatchSize) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddScheduledExecutorConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[32], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1772032);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, poolSize);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, durability);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 24, capacity);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 28, mergeBatchSize);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        StringCodec.encode(clientMessage, mergePolicy);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.poolSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.durability = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
        request.capacity = FixedSizeTypesCodec.decodeInt(initialFrame.content, 24);
        request.mergeBatchSize = FixedSizeTypesCodec.decodeInt(initialFrame.content, 28);
        request.name = StringCodec.decode(iterator);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        request.mergePolicy = StringCodec.decode(iterator);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1772033);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int poolSize;
        public int durability;
        public int capacity;
        @Nullable
        public String splitBrainProtectionName;
        public String mergePolicy;
        public int mergeBatchSize;
    }
}

