/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nullable;

public final class DynamicConfigAddPNCounterConfigCodec {
    public static final int REQUEST_MESSAGE_TYPE = 0x1B1000;
    public static final int RESPONSE_MESSAGE_TYPE = 0x1B1001;
    private static final int REQUEST_REPLICA_COUNT_FIELD_OFFSET = 16;
    private static final int REQUEST_STATISTICS_ENABLED_FIELD_OFFSET = 20;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 21;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;

    private DynamicConfigAddPNCounterConfigCodec() {
    }

    public static ClientMessage encodeRequest(String name, int replicaCount, boolean statisticsEnabled, @Nullable String splitBrainProtectionName) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("DynamicConfig.AddPNCounterConfig");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[21], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1B1000);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, replicaCount);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 20, statisticsEnabled);
        clientMessage.add(initialFrame);
        StringCodec.encode(clientMessage, name);
        CodecUtil.encodeNullable(clientMessage, splitBrainProtectionName, StringCodec::encode);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.replicaCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
        request.statisticsEnabled = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 20);
        request.name = StringCodec.decode(iterator);
        request.splitBrainProtectionName = CodecUtil.decodeNullable(iterator, StringCodec::decode);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 0x1B1001);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public String name;
        public int replicaCount;
        public boolean statisticsEnabled;
        @Nullable
        public String splitBrainProtectionName;
    }
}

