/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import javax.annotation.Nullable;

public final class ClientAddPartitionLostListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 1792;
    public static final int RESPONSE_MESSAGE_TYPE = 1793;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_RESPONSE_FIELD_OFFSET = 16;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 33;
    private static final int EVENT_PARTITION_LOST_PARTITION_ID_FIELD_OFFSET = 16;
    private static final int EVENT_PARTITION_LOST_LOST_BACKUP_COUNT_FIELD_OFFSET = 20;
    private static final int EVENT_PARTITION_LOST_INITIAL_FRAME_SIZE = 24;
    private static final int EVENT_PARTITION_LOST_MESSAGE_TYPE = 1794;

    private ClientAddPartitionLostListenerCodec() {
    }

    public static ClientMessage encodeRequest(boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Client.AddPartitionLostListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1792);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, localOnly);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        return request;
    }

    public static ClientMessage encodeResponse(UUID response) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[33], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1793);
        FixedSizeTypesCodec.encodeUUID(initialFrame.content, 16, response);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        response.response = FixedSizeTypesCodec.decodeUUID(initialFrame.content, 16);
        return response;
    }

    public static ClientMessage encodePartitionLostEvent(int partitionId, int lostBackupCount, @Nullable Address source) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 1794);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, partitionId);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, lostBackupCount);
        clientMessage.add(initialFrame);
        CodecUtil.encodeNullable(clientMessage, source, AddressCodec::encode);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 1794) {
                ClientMessage.Frame initialFrame = iterator.next();
                int partitionId = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                int lostBackupCount = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
                Address source = CodecUtil.decodeNullable(iterator, AddressCodec::decode);
                this.handlePartitionLostEvent(partitionId, lostBackupCount, source);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handlePartitionLostEvent(int var1, int var2, @Nullable Address var3);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
        public UUID response;
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public boolean localOnly;
    }
}

