/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.codec;

import com.hazelcast.client.impl.MemberImpl;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.builtin.CodecUtil;
import com.hazelcast.client.impl.protocol.codec.builtin.EntryListCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.FixedSizeTypesCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListIntegerCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.ListMultiFrameCodec;
import com.hazelcast.client.impl.protocol.codec.builtin.StringCodec;
import com.hazelcast.client.impl.protocol.codec.custom.AddressCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MemberCodec;
import com.hazelcast.client.impl.protocol.codec.custom.MemberInfoCodec;
import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.internal.cluster.MemberInfo;
import com.hazelcast.logging.Logger;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class ClientAddClusterViewListenerCodec {
    public static final int REQUEST_MESSAGE_TYPE = 768;
    public static final int RESPONSE_MESSAGE_TYPE = 769;
    private static final int REQUEST_LOCAL_ONLY_FIELD_OFFSET = 16;
    private static final int REQUEST_INITIAL_FRAME_SIZE = 17;
    private static final int RESPONSE_INITIAL_FRAME_SIZE = 16;
    private static final int EVENT_MEMBERS_VIEW_VERSION_FIELD_OFFSET = 16;
    private static final int EVENT_MEMBERS_VIEW_PARTITION_STATE_VERSION_FIELD_OFFSET = 20;
    private static final int EVENT_MEMBERS_VIEW_INITIAL_FRAME_SIZE = 24;
    private static final int EVENT_MEMBERS_VIEW_MESSAGE_TYPE = 770;
    private static final int EVENT_MEMBER_ATTRIBUTE_CHANGE_OPERATION_TYPE_FIELD_OFFSET = 16;
    private static final int EVENT_MEMBER_ATTRIBUTE_CHANGE_INITIAL_FRAME_SIZE = 20;
    private static final int EVENT_MEMBER_ATTRIBUTE_CHANGE_MESSAGE_TYPE = 771;

    private ClientAddClusterViewListenerCodec() {
    }

    public static ClientMessage encodeRequest(boolean localOnly) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        clientMessage.setRetryable(false);
        clientMessage.setOperationName("Client.AddClusterViewListener");
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[17], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 768);
        FixedSizeTypesCodec.encodeBoolean(initialFrame.content, 16, localOnly);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static RequestParameters decodeRequest(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        RequestParameters request = new RequestParameters();
        ClientMessage.Frame initialFrame = iterator.next();
        request.localOnly = FixedSizeTypesCodec.decodeBoolean(initialFrame.content, 16);
        return request;
    }

    public static ClientMessage encodeResponse() {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[16], 49152);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 769);
        clientMessage.add(initialFrame);
        return clientMessage;
    }

    public static ResponseParameters decodeResponse(ClientMessage clientMessage) {
        ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
        ResponseParameters response = new ResponseParameters();
        iterator.next();
        return response;
    }

    public static ClientMessage encodeMembersViewEvent(int version, Collection<MemberInfo> memberInfos, Collection<Map.Entry<Address, List<Integer>>> partitions, int partitionStateVersion) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[24], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 770);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, version);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 20, partitionStateVersion);
        clientMessage.add(initialFrame);
        ListMultiFrameCodec.encode(clientMessage, memberInfos, MemberInfoCodec::encode);
        EntryListCodec.encode(clientMessage, partitions, AddressCodec::encode, ListIntegerCodec::encode);
        return clientMessage;
    }

    public static ClientMessage encodeMemberAttributeChangeEvent(Member member, String key, int operationType, @Nullable String value) {
        ClientMessage clientMessage = ClientMessage.createForEncode();
        ClientMessage.Frame initialFrame = new ClientMessage.Frame(new byte[20], 49152);
        initialFrame.flags |= 0x200;
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 0, 771);
        FixedSizeTypesCodec.encodeInt(initialFrame.content, 16, operationType);
        clientMessage.add(initialFrame);
        MemberCodec.encode(clientMessage, member);
        StringCodec.encode(clientMessage, key);
        CodecUtil.encodeNullable(clientMessage, value, StringCodec::encode);
        return clientMessage;
    }

    public static abstract class AbstractEventHandler {
        public void handle(ClientMessage clientMessage) {
            int messageType = clientMessage.getMessageType();
            ClientMessage.ForwardFrameIterator iterator = clientMessage.frameIterator();
            if (messageType == 770) {
                ClientMessage.Frame initialFrame = iterator.next();
                int version = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                int partitionStateVersion = FixedSizeTypesCodec.decodeInt(initialFrame.content, 20);
                List<MemberInfo> memberInfos = ListMultiFrameCodec.decode(iterator, MemberInfoCodec::decode);
                List<Map.Entry<Address, List<Integer>>> partitions = EntryListCodec.decode(iterator, AddressCodec::decode, ListIntegerCodec::decode);
                this.handleMembersViewEvent(version, memberInfos, partitions, partitionStateVersion);
                return;
            }
            if (messageType == 771) {
                ClientMessage.Frame initialFrame = iterator.next();
                int operationType = FixedSizeTypesCodec.decodeInt(initialFrame.content, 16);
                MemberImpl member = MemberCodec.decode(iterator);
                String key = StringCodec.decode(iterator);
                String value = CodecUtil.decodeNullable(iterator, StringCodec::decode);
                this.handleMemberAttributeChangeEvent(member, key, operationType, value);
                return;
            }
            Logger.getLogger(super.getClass()).finest("Unknown message type received on event handler :" + messageType);
        }

        public abstract void handleMembersViewEvent(int var1, Collection<MemberInfo> var2, Collection<Map.Entry<Address, List<Integer>>> var3, int var4);

        public abstract void handleMemberAttributeChangeEvent(Member var1, String var2, int var3, @Nullable String var4);
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class ResponseParameters {
    }

    @SuppressFBWarnings(value={"URF_UNREAD_PUBLIC_OR_PROTECTED_FIELD"})
    public static class RequestParameters {
        public boolean localOnly;
    }
}

