/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.cache.impl.JCacheDetector;
import com.hazelcast.cardinality.CardinalityEstimator;
import com.hazelcast.client.Client;
import com.hazelcast.client.ClientService;
import com.hazelcast.client.LoadBalancer;
import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientConnectionStrategyConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.client.cp.internal.CPSubsystemImpl;
import com.hazelcast.client.cp.internal.session.ClientProxySessionManager;
import com.hazelcast.client.impl.ClientExtension;
import com.hazelcast.client.impl.client.DistributedObjectInfo;
import com.hazelcast.client.impl.clientside.ClientConnectionManagerFactory;
import com.hazelcast.client.impl.clientside.ClientDiscoveryService;
import com.hazelcast.client.impl.clientside.ClientDiscoveryServiceBuilder;
import com.hazelcast.client.impl.clientside.ClientDynamicClusterConfig;
import com.hazelcast.client.impl.clientside.ClientExceptionFactory;
import com.hazelcast.client.impl.clientside.ClientICacheManager;
import com.hazelcast.client.impl.clientside.ClientLockReferenceIdGenerator;
import com.hazelcast.client.impl.clientside.ClientLoggingService;
import com.hazelcast.client.impl.clientside.DefaultClientExtension;
import com.hazelcast.client.impl.clientside.LifecycleServiceImpl;
import com.hazelcast.client.impl.connection.AddressProvider;
import com.hazelcast.client.impl.connection.ClientConnectionManager;
import com.hazelcast.client.impl.connection.nio.ClientConnectionManagerImpl;
import com.hazelcast.client.impl.management.ManagementCenterService;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ClientGetDistributedObjectsCodec;
import com.hazelcast.client.impl.proxy.ClientClusterProxy;
import com.hazelcast.client.impl.proxy.PartitionServiceProxy;
import com.hazelcast.client.impl.querycache.ClientQueryCacheContext;
import com.hazelcast.client.impl.spi.ClientClusterService;
import com.hazelcast.client.impl.spi.ClientContext;
import com.hazelcast.client.impl.spi.ClientExecutionService;
import com.hazelcast.client.impl.spi.ClientInvocationService;
import com.hazelcast.client.impl.spi.ClientListenerService;
import com.hazelcast.client.impl.spi.ClientPartitionService;
import com.hazelcast.client.impl.spi.ClientTransactionManagerService;
import com.hazelcast.client.impl.spi.ProxyManager;
import com.hazelcast.client.impl.spi.impl.AbstractClientInvocationService;
import com.hazelcast.client.impl.spi.impl.ClientClusterViewService;
import com.hazelcast.client.impl.spi.impl.ClientExecutionServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientInvocation;
import com.hazelcast.client.impl.spi.impl.ClientInvocationFuture;
import com.hazelcast.client.impl.spi.impl.ClientTransactionManagerServiceImpl;
import com.hazelcast.client.impl.spi.impl.ClientUserCodeDeploymentService;
import com.hazelcast.client.impl.spi.impl.NonSmartClientInvocationService;
import com.hazelcast.client.impl.spi.impl.SmartClientInvocationService;
import com.hazelcast.client.impl.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.client.impl.statistics.ClientStatisticsService;
import com.hazelcast.client.properties.ClientProperty;
import com.hazelcast.client.util.RoundRobinLB;
import com.hazelcast.cluster.Cluster;
import com.hazelcast.collection.IList;
import com.hazelcast.collection.IQueue;
import com.hazelcast.collection.ISet;
import com.hazelcast.config.Config;
import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.DistributedObjectListener;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.IExecutorService;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.crdt.pncounter.PNCounter;
import com.hazelcast.durableexecutor.DurableExecutorService;
import com.hazelcast.flakeidgen.FlakeIdGenerator;
import com.hazelcast.instance.BuildInfoProvider;
import com.hazelcast.internal.diagnostics.BuildInfoPlugin;
import com.hazelcast.internal.diagnostics.ConfigPropertiesPlugin;
import com.hazelcast.internal.diagnostics.Diagnostics;
import com.hazelcast.internal.diagnostics.EventQueuePlugin;
import com.hazelcast.internal.diagnostics.MetricsPlugin;
import com.hazelcast.internal.diagnostics.NetworkingImbalancePlugin;
import com.hazelcast.internal.diagnostics.SystemLogPlugin;
import com.hazelcast.internal.diagnostics.SystemPropertiesPlugin;
import com.hazelcast.internal.metrics.impl.MetricsConfigHelper;
import com.hazelcast.internal.metrics.impl.MetricsRegistryImpl;
import com.hazelcast.internal.metrics.metricsets.ClassLoadingMetricSet;
import com.hazelcast.internal.metrics.metricsets.FileMetricSet;
import com.hazelcast.internal.metrics.metricsets.GarbageCollectionMetricSet;
import com.hazelcast.internal.metrics.metricsets.OperatingSystemMetricSet;
import com.hazelcast.internal.metrics.metricsets.RuntimeMetricSet;
import com.hazelcast.internal.metrics.metricsets.ThreadMetricSet;
import com.hazelcast.internal.nearcache.NearCacheManager;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.internal.util.ConcurrencyDetection;
import com.hazelcast.internal.util.EmptyStatement;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.ServiceLoader;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.map.IMap;
import com.hazelcast.multimap.MultiMap;
import com.hazelcast.partition.PartitionService;
import com.hazelcast.replicatedmap.ReplicatedMap;
import com.hazelcast.ringbuffer.Ringbuffer;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.spi.impl.SerializationServiceSupport;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionService;
import com.hazelcast.topic.ITopic;
import com.hazelcast.transaction.HazelcastXAResource;
import com.hazelcast.transaction.TransactionContext;
import com.hazelcast.transaction.TransactionException;
import com.hazelcast.transaction.TransactionOptions;
import com.hazelcast.transaction.TransactionalTask;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;

public class HazelcastClientInstanceImpl
implements HazelcastInstance,
SerializationServiceSupport {
    private static final AtomicInteger CLIENT_ID = new AtomicInteger();
    private final ConcurrencyDetection concurrencyDetection;
    private final HazelcastProperties properties;
    private final int id = CLIENT_ID.getAndIncrement();
    private final String instanceName;
    private final ClientFailoverConfig clientFailoverConfig;
    private final ClientConfig config;
    private final LifecycleServiceImpl lifecycleService;
    private final ClientConnectionManagerImpl connectionManager;
    private final ClientClusterViewService clusterService;
    private final AbstractClientInvocationService invocationService;
    private final ClientExecutionServiceImpl executionService;
    private final ClientListenerServiceImpl listenerService;
    private final ClientTransactionManagerServiceImpl transactionManager;
    private final ConcurrentMap<String, NearCacheManager> nearCacheManagers;
    private final ProxyManager proxyManager;
    private final ConcurrentMap<String, Object> userContext;
    private final LoadBalancer loadBalancer;
    private final ClientExtension clientExtension;
    private final LoggingService loggingService;
    private final MetricsRegistryImpl metricsRegistry;
    private final ClientStatisticsService clientStatisticsService;
    private final Diagnostics diagnostics;
    private final InternalSerializationService serializationService;
    private final ClientICacheManager hazelcastCacheManager;
    private final ClientQueryCacheContext queryCacheContext;
    private final ClientLockReferenceIdGenerator lockReferenceIdGenerator;
    private final ClientExceptionFactory clientExceptionFactory;
    private final ClientUserCodeDeploymentService userCodeDeploymentService;
    private final ClientDiscoveryService clientDiscoveryService;
    private final ClientProxySessionManager proxySessionManager;
    private final CPSubsystemImpl cpSubsystem;
    private final ManagementCenterService managementCenterService;

    public HazelcastClientInstanceImpl(ClientConfig clientConfig, ClientFailoverConfig clientFailoverConfig, ClientConnectionManagerFactory clientConnectionManagerFactory, AddressProvider externalAddressProvider) {
        assert (clientConfig != null || clientFailoverConfig != null) : "At most one type of config can be provided";
        assert (clientConfig == null || clientFailoverConfig == null) : "At least one config should be provided ";
        this.config = clientConfig != null ? clientConfig : clientFailoverConfig.getClientConfigs().get(0);
        this.clientFailoverConfig = clientFailoverConfig;
        this.instanceName = this.config.getInstanceName() != null ? this.config.getInstanceName() : "hz.client_" + this.id;
        String loggingType = this.config.getProperty(ClusterProperty.LOGGING_TYPE.getName());
        this.loggingService = new ClientLoggingService(this.config.getClusterName(), loggingType, BuildInfoProvider.getBuildInfo(), this.instanceName);
        if (clientConfig != null) {
            MetricsConfigHelper.overrideClientMetricsConfig(clientConfig, this.getLoggingService().getLogger(MetricsConfigHelper.class));
        } else {
            for (ClientConfig failoverClientConfig : clientFailoverConfig.getClientConfigs()) {
                MetricsConfigHelper.overrideClientMetricsConfig(failoverClientConfig, this.getLoggingService().getLogger(MetricsConfigHelper.class));
            }
        }
        ClassLoader classLoader = this.config.getClassLoader();
        this.properties = new HazelcastProperties(this.config.getProperties());
        this.concurrencyDetection = this.initConcurrencyDetection();
        this.clientExtension = this.createClientInitializer(classLoader);
        this.clientExtension.beforeStart(this);
        this.lifecycleService = new LifecycleServiceImpl(this);
        this.metricsRegistry = this.initMetricsRegistry();
        this.serializationService = this.clientExtension.createSerializationService((byte)-1);
        this.proxyManager = new ProxyManager(this);
        this.executionService = this.initExecutionService();
        this.loadBalancer = this.initLoadBalancer(this.config);
        this.transactionManager = new ClientTransactionManagerServiceImpl(this);
        this.clientDiscoveryService = this.initClientDiscoveryService(externalAddressProvider);
        this.connectionManager = (ClientConnectionManagerImpl)clientConnectionManagerFactory.createConnectionManager(this);
        this.invocationService = this.initInvocationService();
        this.listenerService = new ClientListenerServiceImpl(this);
        this.clusterService = new ClientClusterViewService(this);
        this.userContext = new ConcurrentHashMap<String, Object>();
        this.userContext.putAll(this.config.getUserContext());
        this.diagnostics = this.initDiagnostics();
        this.hazelcastCacheManager = new ClientICacheManager(this);
        this.queryCacheContext = new ClientQueryCacheContext(this);
        this.lockReferenceIdGenerator = new ClientLockReferenceIdGenerator();
        this.nearCacheManagers = this.createNearCacheManagers();
        this.clientExceptionFactory = this.initClientExceptionFactory();
        this.clientStatisticsService = new ClientStatisticsService(this);
        this.userCodeDeploymentService = new ClientUserCodeDeploymentService(this.config.getUserCodeDeploymentConfig(), classLoader);
        this.proxySessionManager = new ClientProxySessionManager(this);
        this.cpSubsystem = new CPSubsystemImpl(this);
        this.managementCenterService = new ManagementCenterService(this, this.serializationService);
    }

    private ConcurrentMap<String, NearCacheManager> createNearCacheManagers() {
        ConcurrentHashMap<String, NearCacheManager> nearCacheManagers = new ConcurrentHashMap<String, NearCacheManager>();
        nearCacheManagers.put("hz:impl:mapService", this.clientExtension.createNearCacheManager());
        nearCacheManagers.put("hz:impl:replicatedMapService", this.clientExtension.createNearCacheManager());
        nearCacheManagers.put("hz:impl:cacheService", this.clientExtension.createNearCacheManager());
        return nearCacheManagers;
    }

    private ConcurrencyDetection initConcurrencyDetection() {
        boolean backPressureEnabled;
        boolean writeThrough = this.properties.getBoolean(ClientProperty.IO_WRITE_THROUGH_ENABLED);
        boolean dynamicResponse = this.properties.getBoolean(ClientProperty.RESPONSE_THREAD_DYNAMIC);
        boolean bl = backPressureEnabled = this.properties.getInteger(ClientProperty.MAX_CONCURRENT_INVOCATIONS) < Integer.MAX_VALUE;
        if (writeThrough || dynamicResponse || backPressureEnabled) {
            return ConcurrencyDetection.createEnabled(this.properties.getInteger(ClientProperty.CONCURRENT_WINDOW_MS));
        }
        return ConcurrencyDetection.createDisabled();
    }

    private ClientDiscoveryService initClientDiscoveryService(AddressProvider externalAddressProvider) {
        List<ClientConfig> configs;
        int tryCount;
        if (this.clientFailoverConfig == null) {
            tryCount = 0;
            configs = Collections.singletonList(this.config);
        } else {
            tryCount = this.clientFailoverConfig.getTryCount();
            configs = this.clientFailoverConfig.getClientConfigs();
        }
        ClientDiscoveryServiceBuilder builder = new ClientDiscoveryServiceBuilder(tryCount, configs, this.loggingService, externalAddressProvider, this.properties, this.clientExtension);
        return builder.build();
    }

    private Diagnostics initDiagnostics() {
        String name = "diagnostics-client-" + this.id + "-" + System.currentTimeMillis();
        ILogger logger = this.loggingService.getLogger(Diagnostics.class);
        return new Diagnostics(name, logger, this.instanceName, this.properties);
    }

    private MetricsRegistryImpl initMetricsRegistry() {
        ILogger logger = this.loggingService.getLogger(MetricsRegistryImpl.class);
        return new MetricsRegistryImpl(this.getName(), logger, MetricsConfigHelper.clientMetricsLevel(this.properties, this.loggingService.getLogger(MetricsConfigHelper.class)));
    }

    private void startMetrics() {
        RuntimeMetricSet.register(this.metricsRegistry);
        GarbageCollectionMetricSet.register(this.metricsRegistry);
        OperatingSystemMetricSet.register(this.metricsRegistry);
        ThreadMetricSet.register(this.metricsRegistry);
        ClassLoadingMetricSet.register(this.metricsRegistry);
        FileMetricSet.register(this.metricsRegistry);
        this.metricsRegistry.registerStaticMetrics(this.clientExtension.getMemoryStats(), "memory");
        this.metricsRegistry.provideMetrics(this.clientExtension);
        this.metricsRegistry.provideMetrics(this.executionService);
    }

    private LoadBalancer initLoadBalancer(ClientConfig config) {
        LoadBalancer lb = config.getLoadBalancer();
        if (lb == null) {
            lb = new RoundRobinLB();
        }
        return lb;
    }

    private AbstractClientInvocationService initInvocationService() {
        ClientNetworkConfig networkConfig = this.config.getNetworkConfig();
        if (networkConfig.isSmartRouting()) {
            return new SmartClientInvocationService(this);
        }
        return new NonSmartClientInvocationService(this);
    }

    public int getId() {
        return this.id;
    }

    private ClientExtension createClientInitializer(ClassLoader classLoader) {
        try {
            String factoryId = ClientExtension.class.getName();
            Iterator<ClientExtension> iter = ServiceLoader.iterator(ClientExtension.class, factoryId, classLoader);
            while (iter.hasNext()) {
                ClientExtension initializer = iter.next();
                if (initializer.getClass().equals(DefaultClientExtension.class)) continue;
                return initializer;
            }
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
        return new DefaultClientExtension();
    }

    private ClientExecutionServiceImpl initExecutionService() {
        return new ClientExecutionServiceImpl(this.instanceName, this.config.getClassLoader(), this.properties, this.config.getExecutorPoolSize(), this.loggingService);
    }

    public void start() {
        try {
            this.lifecycleService.start();
            this.startMetrics();
            this.invocationService.start();
            ClientContext clientContext = new ClientContext(this);
            this.userCodeDeploymentService.start();
            this.connectionManager.start();
            this.diagnostics.start();
            this.diagnostics.register(new BuildInfoPlugin(this.loggingService.getLogger(BuildInfoPlugin.class)));
            this.diagnostics.register(new ConfigPropertiesPlugin(this.loggingService.getLogger(ConfigPropertiesPlugin.class), this.properties));
            this.diagnostics.register(new SystemPropertiesPlugin(this.loggingService.getLogger(SystemPropertiesPlugin.class)));
            this.diagnostics.register(new MetricsPlugin(this.loggingService.getLogger(MetricsPlugin.class), this.metricsRegistry, this.properties));
            this.diagnostics.register(new SystemLogPlugin(this.properties, this.connectionManager, this, this.loggingService.getLogger(SystemLogPlugin.class)));
            this.diagnostics.register(new NetworkingImbalancePlugin(this.properties, this.connectionManager.getNetworking(), this.loggingService.getLogger(NetworkingImbalancePlugin.class)));
            this.diagnostics.register(new EventQueuePlugin(this.loggingService.getLogger(EventQueuePlugin.class), this.listenerService.getEventExecutor(), this.properties));
            this.metricsRegistry.provideMetrics(this.listenerService);
            this.proxyManager.init(this.config, clientContext);
            this.listenerService.start();
            if (this.invocationService instanceof SmartClientInvocationService) {
                ((SmartClientInvocationService)this.invocationService).addBackupListener();
            }
            this.clusterService.start();
            ClientConnectionStrategyConfig connectionStrategyConfig = this.config.getConnectionStrategyConfig();
            if (!connectionStrategyConfig.isAsyncStart()) {
                this.connectionManager.tryOpenConnectionToAllMembers();
            }
            this.loadBalancer.init(this.getCluster(), this.config);
            this.clientStatisticsService.start();
            this.clientExtension.afterStart(this);
            this.cpSubsystem.init(clientContext);
            this.sendStateToCluster();
        }
        catch (Throwable e) {
            try {
                this.lifecycleService.terminate();
            }
            catch (Throwable t) {
                EmptyStatement.ignore(t);
            }
            ExceptionUtil.rethrow(e);
        }
    }

    public MetricsRegistryImpl getMetricsRegistry() {
        return this.metricsRegistry;
    }

    @Override
    @Nonnull
    public HazelcastXAResource getXAResource() {
        return (HazelcastXAResource)this.getDistributedObject("hz:impl:xaService", "hz:impl:xaService");
    }

    @Override
    @Nonnull
    public Config getConfig() {
        return new ClientDynamicClusterConfig(this);
    }

    public HazelcastProperties getProperties() {
        return this.properties;
    }

    @Override
    @Nonnull
    public String getName() {
        return this.instanceName;
    }

    @Override
    @Nonnull
    public <E> IQueue<E> getQueue(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a queue instance with a null name is not allowed!");
        return (IQueue)this.getDistributedObject("hz:impl:queueService", name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getTopic(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:topicService", name);
    }

    @Override
    @Nonnull
    public <E> ISet<E> getSet(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a set instance with a null name is not allowed!");
        return (ISet)this.getDistributedObject("hz:impl:setService", name);
    }

    @Override
    @Nonnull
    public <E> IList<E> getList(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a list instance with a null name is not allowed!");
        return (IList)this.getDistributedObject("hz:impl:listService", name);
    }

    @Override
    @Nonnull
    public <K, V> IMap<K, V> getMap(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a map instance with a null name is not allowed!");
        return (IMap)this.getDistributedObject("hz:impl:mapService", name);
    }

    @Override
    @Nonnull
    public <K, V> MultiMap<K, V> getMultiMap(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a multi-map instance with a null name is not allowed!");
        return (MultiMap)this.getDistributedObject("hz:impl:multiMapService", name);
    }

    @Override
    @Nonnull
    public <K, V> ReplicatedMap<K, V> getReplicatedMap(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a replicated map instance with a null name is not allowed!");
        return (ReplicatedMap)this.getDistributedObject("hz:impl:replicatedMapService", name);
    }

    @Override
    @Nonnull
    public <E> ITopic<E> getReliableTopic(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a topic instance with a null name is not allowed!");
        return (ITopic)this.getDistributedObject("hz:impl:reliableTopicService", name);
    }

    @Override
    @Nonnull
    public <E> Ringbuffer<E> getRingbuffer(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a ringbuffer instance with a null name is not allowed!");
        return (Ringbuffer)this.getDistributedObject("hz:impl:ringbufferService", name);
    }

    @Override
    public ClientICacheManager getCacheManager() {
        return this.hazelcastCacheManager;
    }

    @Override
    @Nonnull
    public Cluster getCluster() {
        return new ClientClusterProxy(this.clusterService);
    }

    @Override
    @Nonnull
    public Client getLocalEndpoint() {
        return this.clusterService.getLocalClient();
    }

    @Override
    @Nonnull
    public IExecutorService getExecutorService(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an executor instance with a null name is not allowed!");
        return (IExecutorService)this.getDistributedObject("hz:impl:executorService", name);
    }

    @Override
    @Nonnull
    public DurableExecutorService getDurableExecutorService(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a durable executor instance with a null name is not allowed!");
        return (DurableExecutorService)this.getDistributedObject("hz:impl:durableExecutorService", name);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(task);
    }

    @Override
    public <T> T executeTransaction(@Nonnull TransactionOptions options, @Nonnull TransactionalTask<T> task) throws TransactionException {
        return this.transactionManager.executeTransaction(options, task);
    }

    @Override
    public TransactionContext newTransactionContext() {
        return this.transactionManager.newTransactionContext();
    }

    @Override
    public TransactionContext newTransactionContext(@Nonnull TransactionOptions options) {
        Preconditions.checkNotNull(options, "TransactionOptions must not be null!");
        return this.transactionManager.newTransactionContext(options);
    }

    public ClientTransactionManagerService getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    @Nonnull
    public FlakeIdGenerator getFlakeIdGenerator(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a Flake ID-generator instance with a null name is not allowed!");
        return (FlakeIdGenerator)this.getDistributedObject("hz:impl:flakeIdGeneratorService", name);
    }

    @Override
    @Nonnull
    public CardinalityEstimator getCardinalityEstimator(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a cardinality estimator instance with a null name is not allowed!");
        return (CardinalityEstimator)this.getDistributedObject("hz:impl:cardinalityEstimatorService", name);
    }

    @Override
    @Nonnull
    public PNCounter getPNCounter(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a PN counter instance with a null name is not allowed!");
        return (PNCounter)this.getDistributedObject("hz:impl:PNCounterService", name);
    }

    @Override
    @Nonnull
    public IScheduledExecutorService getScheduledExecutorService(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a scheduled executor instance with a null name is not allowed!");
        return (IScheduledExecutorService)this.getDistributedObject("hz:impl:scheduledExecutorService", name);
    }

    @Override
    public Collection<DistributedObject> getDistributedObjects() {
        try {
            ClientMessage request = ClientGetDistributedObjectsCodec.encodeRequest();
            ClientInvocationFuture future = new ClientInvocation(this, request, this.getName()).invoke();
            ClientMessage response = (ClientMessage)future.get();
            ClientGetDistributedObjectsCodec.ResponseParameters resultParameters = ClientGetDistributedObjectsCodec.decodeResponse(response);
            Collection<? extends DistributedObject> distributedObjects = this.proxyManager.getDistributedObjects();
            HashSet<DistributedObjectInfo> localDistributedObjects = new HashSet<DistributedObjectInfo>();
            for (DistributedObject distributedObject : distributedObjects) {
                localDistributedObjects.add(new DistributedObjectInfo(distributedObject.getServiceName(), distributedObject.getName()));
            }
            List<DistributedObjectInfo> newDistributedObjectInfo = resultParameters.response;
            for (DistributedObjectInfo distributedObjectInfo : newDistributedObjectInfo) {
                localDistributedObjects.remove(distributedObjectInfo);
                this.getDistributedObject(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName(), false);
            }
            for (DistributedObjectInfo distributedObjectInfo : localDistributedObjects) {
                this.proxyManager.destroyProxyLocally(distributedObjectInfo.getServiceName(), distributedObjectInfo.getName());
            }
            return this.proxyManager.getDistributedObjects();
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    @Override
    public UUID addDistributedObjectListener(@Nonnull DistributedObjectListener distributedObjectListener) {
        Preconditions.checkNotNull(distributedObjectListener, "DistributedObjectListener must not be null!");
        return this.proxyManager.addDistributedObjectListener(distributedObjectListener);
    }

    @Override
    public boolean removeDistributedObjectListener(@Nonnull UUID registrationId) {
        Preconditions.checkNotNull(registrationId, "Registration ID must not be null!");
        return this.proxyManager.removeDistributedObjectListener(registrationId);
    }

    @Override
    @Nonnull
    public PartitionService getPartitionService() {
        return new PartitionServiceProxy(this.clusterService, this.listenerService);
    }

    @Override
    @Nonnull
    public SplitBrainProtectionService getSplitBrainProtectionService() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public ClientService getClientService() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public LoggingService getLoggingService() {
        return this.loggingService;
    }

    @Override
    @Nonnull
    public LifecycleService getLifecycleService() {
        return this.lifecycleService;
    }

    @Override
    @Nonnull
    public <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name) {
        return this.getDistributedObject(serviceName, name, true);
    }

    private <T extends DistributedObject> T getDistributedObject(@Nonnull String serviceName, @Nonnull String name, boolean remote) {
        if (remote) {
            return (T)this.proxyManager.getOrCreateProxy(serviceName, name);
        }
        return (T)this.proxyManager.getOrCreateLocalProxy(serviceName, name);
    }

    @Override
    @Nonnull
    public CPSubsystem getCPSubsystem() {
        return this.cpSubsystem;
    }

    @Override
    @Nonnull
    public ConcurrentMap<String, Object> getUserContext() {
        return this.userContext;
    }

    public ClientConfig getClientConfig() {
        return this.config;
    }

    @Override
    public InternalSerializationService getSerializationService() {
        return this.serializationService;
    }

    public ClientUserCodeDeploymentService getUserCodeDeploymentService() {
        return this.userCodeDeploymentService;
    }

    public ClientProxySessionManager getProxySessionManager() {
        return this.proxySessionManager;
    }

    public ProxyManager getProxyManager() {
        return this.proxyManager;
    }

    public ClientConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public ClientClusterService getClientClusterService() {
        return this.clusterService;
    }

    public ClientExecutionService getClientExecutionService() {
        return this.executionService;
    }

    public ClientPartitionService getClientPartitionService() {
        return this.clusterService;
    }

    public ClientInvocationService getInvocationService() {
        return this.invocationService;
    }

    public ClientListenerService getListenerService() {
        return this.listenerService;
    }

    public Map<String, NearCacheManager> getNearCacheManagers() {
        return this.nearCacheManagers;
    }

    public NearCacheManager getNearCacheManager(String serviceName) {
        return (NearCacheManager)this.nearCacheManagers.get(serviceName);
    }

    public LoadBalancer getLoadBalancer() {
        return this.loadBalancer;
    }

    public ClientExtension getClientExtension() {
        return this.clientExtension;
    }

    @Override
    public void shutdown() {
        this.getLifecycleService().shutdown();
    }

    void onGracefulShutdown() {
        this.proxySessionManager.shutdownAndAwait();
    }

    public void doShutdown() {
        this.proxyManager.destroy();
        this.connectionManager.shutdown();
        this.clientDiscoveryService.shutdown();
        this.clusterService.shutdown();
        this.transactionManager.shutdown();
        this.invocationService.shutdown();
        this.executionService.shutdown();
        this.listenerService.shutdown();
        this.clientStatisticsService.shutdown();
        this.metricsRegistry.shutdown();
        this.diagnostics.shutdown();
        this.serializationService.dispose();
    }

    public ClientLockReferenceIdGenerator getLockReferenceIdGenerator() {
        return this.lockReferenceIdGenerator;
    }

    private ClientExceptionFactory initClientExceptionFactory() {
        boolean jCacheAvailable = JCacheDetector.isJCacheAvailable(this.getClientConfig().getClassLoader());
        return new ClientExceptionFactory(jCacheAvailable);
    }

    public ClientExceptionFactory getClientExceptionFactory() {
        return this.clientExceptionFactory;
    }

    public ClientDiscoveryService getClientDiscoveryService() {
        return this.clientDiscoveryService;
    }

    public ClientFailoverConfig getFailoverConfig() {
        return this.clientFailoverConfig;
    }

    public ClientQueryCacheContext getQueryCacheContext() {
        return this.queryCacheContext;
    }

    public ManagementCenterService getManagementCenterService() {
        return this.managementCenterService;
    }

    public ConcurrencyDetection getConcurrencyDetection() {
        return this.concurrencyDetection;
    }

    public void clear() {
        ILogger logger = this.loggingService.getLogger(HazelcastInstance.class);
        logger.info("Resetting local state of the client");
        this.nearCacheManagers.values().forEach(NearCacheManager::clearAllNearCaches);
        this.clusterService.reset();
        this.connectionManager.reset();
    }

    public void sendStateToCluster() throws ExecutionException, InterruptedException {
        this.userCodeDeploymentService.deploy(this);
        this.proxyManager.createDistributedObjectsOnCluster();
        this.queryCacheContext.recreateAllCaches();
    }

    public ClientStatisticsService getClientStatisticsService() {
        return this.clientStatisticsService;
    }
}

