/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.partition.operation;

import com.hazelcast.internal.partition.MigrationInfo;
import com.hazelcast.internal.partition.ReplicaFragmentMigrationState;
import com.hazelcast.internal.partition.impl.InternalPartitionServiceImpl;
import com.hazelcast.internal.partition.impl.PartitionReplicaManager;
import com.hazelcast.internal.partition.operation.BaseMigrationDestinationOperation;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ServiceNamespace;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;

public class MigrationOperation
extends BaseMigrationDestinationOperation {
    private ReplicaFragmentMigrationState fragmentMigrationState;
    private boolean firstFragment;
    private boolean lastFragment;

    public MigrationOperation() {
    }

    public MigrationOperation(MigrationInfo migrationInfo, int partitionStateVersion, ReplicaFragmentMigrationState fragmentMigrationState, boolean firstFragment, boolean lastFragment) {
        super(migrationInfo, partitionStateVersion);
        this.fragmentMigrationState = fragmentMigrationState;
        this.firstFragment = firstFragment;
        this.lastFragment = lastFragment;
    }

    @Override
    public void run() throws Exception {
        this.verifyMasterOnMigrationDestination();
        this.setActiveMigration();
        try {
            this.doRun();
        }
        catch (Throwable t) {
            this.logMigrationFailure(t);
            this.success = false;
            this.failureReason = t;
        }
        finally {
            this.onMigrationComplete();
            if (!this.success) {
                this.onExecutionFailure(this.failureReason);
            }
        }
    }

    private void doRun() throws Exception {
        if (this.migrationInfo.startProcessing()) {
            try {
                if (this.firstFragment) {
                    this.executeBeforeMigrations();
                }
                for (Operation migrationOperation : this.fragmentMigrationState.getMigrationOperations()) {
                    this.runMigrationOperation(migrationOperation);
                }
                this.success = true;
            }
            catch (Throwable e) {
                this.success = false;
                this.failureReason = e;
                this.getLogger().severe("Error while executing replication operations " + this.migrationInfo, e);
            }
            finally {
                this.afterMigrate();
            }
        } else {
            this.success = false;
            this.logMigrationCancelled();
        }
    }

    private void afterMigrate() {
        ILogger logger = this.getLogger();
        if (this.success) {
            InternalPartitionServiceImpl partitionService = (InternalPartitionServiceImpl)this.getService();
            PartitionReplicaManager replicaManager = partitionService.getReplicaManager();
            int destinationNewReplicaIndex = this.migrationInfo.getDestinationNewReplicaIndex();
            int replicaOffset = destinationNewReplicaIndex <= 1 ? 1 : destinationNewReplicaIndex;
            Map<ServiceNamespace, long[]> namespaceVersions = this.fragmentMigrationState.getNamespaceVersionMap();
            for (Map.Entry<ServiceNamespace, long[]> e : namespaceVersions.entrySet()) {
                ServiceNamespace namespace = e.getKey();
                long[] replicaVersions = e.getValue();
                replicaManager.setPartitionReplicaVersions(this.migrationInfo.getPartitionId(), namespace, replicaVersions, replicaOffset);
                if (!logger.isFinestEnabled()) continue;
                logger.finest("ReplicaVersions are set after migration. partitionId=" + this.migrationInfo.getPartitionId() + " namespace: " + namespace + " replicaVersions=" + Arrays.toString(replicaVersions));
            }
        } else if (logger.isFinestEnabled()) {
            logger.finest("ReplicaVersions are not set since migration failed. partitionId=" + this.migrationInfo.getPartitionId());
        }
        this.migrationInfo.doneProcessing();
    }

    @Override
    public void onExecutionFailure(Throwable e) {
        if (this.fragmentMigrationState == null) {
            return;
        }
        Collection<Operation> tasks = this.fragmentMigrationState.getMigrationOperations();
        if (tasks != null) {
            for (Operation op : tasks) {
                this.prepareOperation(op);
                this.onOperationFailure(op, e);
            }
        }
    }

    private void onOperationFailure(Operation op, Throwable e) {
        try {
            op.onExecutionFailure(e);
        }
        catch (Throwable t) {
            this.getLogger().warning("While calling operation.onFailure(). op: " + op, t);
        }
    }

    @Override
    public int getId() {
        return 18;
    }

    @Override
    void onMigrationStart() {
        if (this.firstFragment) {
            super.onMigrationStart();
        }
    }

    @Override
    void onMigrationComplete(boolean result) {
        if (this.lastFragment) {
            super.onMigrationComplete(result);
        }
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        this.fragmentMigrationState.writeData(out);
        out.writeBoolean(this.firstFragment);
        out.writeBoolean(this.lastFragment);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.fragmentMigrationState = new ReplicaFragmentMigrationState();
        this.fragmentMigrationState.readData(in);
        this.firstFragment = in.readBoolean();
        this.lastFragment = in.readBoolean();
    }
}

