/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.internal.metrics.MetricsProvider;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.util.RuntimeAvailableProcessors;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.properties.GroupProperty;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.util.executor.LoggingScheduledExecutor;
import com.hazelcast.util.executor.PoolExecutorThreadFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public final class ClientExecutionServiceImpl
implements ClientExecutionService,
MetricsProvider {
    public static final HazelcastProperty INTERNAL_EXECUTOR_POOL_SIZE = new HazelcastProperty("hazelcast.client.internal.executor.pool.size", 3);
    public static final long TERMINATE_TIMEOUT_SECONDS = 30L;
    private final ILogger logger;
    private final ExecutorService userExecutor;
    private final ScheduledExecutorService internalExecutor;

    public ClientExecutionServiceImpl(String name, ClassLoader classLoader, HazelcastProperties properties, int poolSize, LoggingService loggingService) {
        int executorPoolSize;
        int internalPoolSize = properties.getInteger(INTERNAL_EXECUTOR_POOL_SIZE);
        if (internalPoolSize <= 0) {
            internalPoolSize = Integer.parseInt(INTERNAL_EXECUTOR_POOL_SIZE.getDefaultValue());
        }
        if ((executorPoolSize = poolSize) <= 0) {
            executorPoolSize = RuntimeAvailableProcessors.get();
        }
        this.logger = loggingService.getLogger(ClientExecutionService.class);
        this.internalExecutor = new LoggingScheduledExecutor(this.logger, internalPoolSize, new PoolExecutorThreadFactory(name + ".internal-", classLoader), properties.getBoolean(GroupProperty.TASK_SCHEDULER_REMOVE_ON_CANCEL), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "Internal executor rejected task: " + r + ", because client is shutting down...";
                ClientExecutionServiceImpl.this.logger.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
        this.userExecutor = new ThreadPoolExecutor(executorPoolSize, executorPoolSize, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new PoolExecutorThreadFactory(name + ".user-", classLoader), new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                String message = "User executor rejected task: " + r + ", because client is shutting down...";
                ClientExecutionServiceImpl.this.logger.finest(message);
                throw new RejectedExecutionException(message);
            }
        });
    }

    @Override
    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.internalExecutor.schedule(command, delay, unit);
    }

    @Override
    public <V> ScheduledFuture<Future<V>> schedule(Callable<V> command, long delay, TimeUnit unit) {
        return this.internalExecutor.schedule(command, delay, unit);
    }

    @Override
    public ScheduledFuture<?> scheduleWithRepetition(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.internalExecutor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    @Override
    public void execute(Runnable command) {
        this.internalExecutor.execute(command);
    }

    @Override
    public ExecutorService getUserExecutor() {
        return this.userExecutor;
    }

    @Probe(level=ProbeLevel.MANDATORY)
    public int getUserExecutorQueueSize() {
        return ((ThreadPoolExecutor)this.userExecutor).getQueue().size();
    }

    public void shutdown() {
        ClientExecutionServiceImpl.shutdownExecutor("user", this.userExecutor, this.logger);
        ClientExecutionServiceImpl.shutdownExecutor("internal", this.internalExecutor, this.logger);
    }

    public static void shutdownExecutor(String name, ExecutorService executor, ILogger logger) {
        executor.shutdown();
        try {
            boolean success = executor.awaitTermination(30L, TimeUnit.SECONDS);
            if (!success) {
                logger.warning(name + " executor awaitTermination could not complete in " + 30L + " seconds");
            }
        }
        catch (InterruptedException e) {
            logger.warning(name + " executor await termination is interrupted", e);
        }
    }

    @Override
    public void provideMetrics(MetricsRegistry registry) {
        registry.scanAndRegister(this, "executionService");
    }
}

