/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.operations;

import com.hazelcast.client.impl.ClientEngineImpl;
import com.hazelcast.client.impl.operations.AbstractClientOperation;
import com.hazelcast.core.Member;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PostJoinClientOperation
extends AbstractClientOperation {
    private Map<String, String> mappings;

    public PostJoinClientOperation() {
    }

    public PostJoinClientOperation(Map<String, String> mappings) {
        this.mappings = mappings;
    }

    @Override
    public void run() throws Exception {
        if (this.mappings == null) {
            return;
        }
        ClientEngineImpl engine = (ClientEngineImpl)this.getService();
        Set<Member> members = this.getNodeEngine().getClusterService().getMembers();
        HashSet<String> uuids = new HashSet<String>();
        for (Member member : members) {
            uuids.add(member.getUuid());
        }
        for (Map.Entry entry : this.mappings.entrySet()) {
            String ownerMemberUuid = (String)entry.getValue();
            if (!uuids.contains(ownerMemberUuid)) continue;
            engine.addOwnershipMapping((String)entry.getKey(), ownerMemberUuid);
        }
    }

    @Override
    public String getServiceName() {
        return "hz:core:clientEngine";
    }

    @Override
    public boolean returnsResponse() {
        return false;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        if (this.mappings == null) {
            out.writeInt(0);
            return;
        }
        int len = this.mappings.size();
        out.writeInt(len);
        for (Map.Entry<String, String> entry : this.mappings.entrySet()) {
            out.writeUTF(entry.getKey());
            out.writeUTF(entry.getValue());
        }
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int len = in.readInt();
        this.mappings = new HashMap<String, String>(len);
        for (int i = 0; i < len; ++i) {
            String clientUuid = in.readUTF();
            String ownerUuid = in.readUTF();
            this.mappings.put(clientUuid, ownerUuid);
        }
    }

    @Override
    public int getId() {
        return 3;
    }
}

