/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractHazelcastCacheManager;
import com.hazelcast.cache.impl.CacheProxy;
import com.hazelcast.cache.impl.HazelcastServerCachingProvider;
import com.hazelcast.cache.impl.ICacheInternal;
import com.hazelcast.cache.impl.ICacheService;
import com.hazelcast.cache.impl.operation.CacheCreateConfigOperation;
import com.hazelcast.cache.impl.operation.CacheGetConfigOperation;
import com.hazelcast.cache.impl.operation.CacheManagementConfigOperation;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.Member;
import com.hazelcast.instance.HazelcastInstanceImpl;
import com.hazelcast.instance.HazelcastInstanceProxy;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.util.FutureUtil;
import com.hazelcast.util.Preconditions;
import java.net.URI;
import java.util.ArrayList;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;

public class HazelcastServerCacheManager
extends AbstractHazelcastCacheManager {
    private final HazelcastInstanceImpl instance;
    private final NodeEngine nodeEngine;
    private final ICacheService cacheService;

    public HazelcastServerCacheManager(HazelcastServerCachingProvider cachingProvider, HazelcastInstance hazelcastInstance, URI uri, ClassLoader classLoader, Properties properties) {
        super(cachingProvider, hazelcastInstance, uri, classLoader, properties);
        this.instance = hazelcastInstance instanceof HazelcastInstanceProxy ? ((HazelcastInstanceProxy)hazelcastInstance).getOriginal() : (HazelcastInstanceImpl)hazelcastInstance;
        this.nodeEngine = this.instance.node.getNodeEngine();
        this.cacheService = (ICacheService)this.nodeEngine.getService("hz:impl:cacheService");
    }

    public void enableManagement(String cacheName, boolean enabled) {
        this.checkIfManagerNotClosed();
        Preconditions.checkNotNull(cacheName, "cacheName cannot be null");
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.setManagementEnabled(null, cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, false, enabled);
    }

    public void enableStatistics(String cacheName, boolean enabled) {
        this.checkIfManagerNotClosed();
        Preconditions.checkNotNull(cacheName, "cacheName cannot be null");
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        this.cacheService.setStatisticsEnabled(null, cacheNameWithPrefix, enabled);
        this.enableStatisticManagementOnOtherNodes(cacheName, true, enabled);
    }

    private void enableStatisticManagementOnOtherNodes(String cacheName, boolean statOrMan, boolean enabled) {
        String cacheNameWithPrefix = this.getCacheNameWithPrefix(cacheName);
        Set<Member> members = this.nodeEngine.getClusterService().getMembers();
        ArrayList futures = new ArrayList();
        for (Member member : members) {
            if (member.localMember()) continue;
            CacheManagementConfigOperation op = new CacheManagementConfigOperation(cacheNameWithPrefix, statOrMan, enabled);
            InternalCompletableFuture future = this.nodeEngine.getOperationService().invokeOnTarget("hz:impl:cacheService", op, member.getAddress());
            futures.add(future);
        }
        FutureUtil.waitWithDeadline(futures, 60L, TimeUnit.SECONDS);
    }

    @Override
    protected <K, V> void addCacheConfigIfAbsent(CacheConfig<K, V> cacheConfig) {
        this.cacheService.putCacheConfigIfAbsent(cacheConfig);
    }

    @Override
    protected <K, V> CacheConfig<K, V> findCacheConfig(String cacheName, String simpleCacheName, boolean createAlsoOnOthers, boolean syncCreate) {
        CacheConfig config = this.cacheService.getCacheConfig(cacheName);
        if (config == null) {
            config = this.cacheService.findCacheConfig(simpleCacheName);
            if (config != null) {
                config.setManagerPrefix(cacheName.substring(0, cacheName.lastIndexOf(simpleCacheName)));
            } else {
                config = this.getCacheConfig(cacheName, simpleCacheName);
            }
        }
        if (config != null) {
            this.createCacheConfig(cacheName, config, createAlsoOnOthers, syncCreate);
        }
        return config;
    }

    @Override
    protected <K, V> CacheConfig<K, V> createCacheConfig(String cacheName, CacheConfig<K, V> config, boolean createAlsoOnOthers, boolean syncCreate) {
        CacheConfig currentCacheConfig = this.cacheService.getCacheConfig(cacheName);
        OperationService operationService = this.nodeEngine.getOperationService();
        CacheCreateConfigOperation op = new CacheCreateConfigOperation(config, createAlsoOnOthers);
        InternalCompletableFuture future = operationService.invokeOnTarget("hz:impl:cacheService", op, this.nodeEngine.getThisAddress());
        if (syncCreate) {
            return (CacheConfig)future.join();
        }
        return currentCacheConfig;
    }

    @Override
    protected <K, V> ICacheInternal<K, V> createCacheProxy(CacheConfig<K, V> cacheConfig) {
        CacheProxy cacheProxy = (CacheProxy)this.instance.getCacheManager().getCacheByFullName(cacheConfig.getNameWithPrefix());
        cacheProxy.setCacheManager(this);
        return cacheProxy;
    }

    @Override
    protected <K, V> CacheConfig<K, V> getCacheConfig(String cacheNameWithPrefix, String cacheName) {
        CacheGetConfigOperation op = new CacheGetConfigOperation(cacheNameWithPrefix, cacheName);
        int partitionId = this.nodeEngine.getPartitionService().getPartitionId(cacheNameWithPrefix);
        InternalCompletableFuture f = this.nodeEngine.getOperationService().invokeOnPartition("hz:impl:cacheService", op, partitionId);
        return (CacheConfig)f.join();
    }

    @Override
    protected void removeCacheConfigFromLocal(String cacheNameWithPrefix) {
        this.cacheService.deleteCacheConfig(cacheNameWithPrefix);
        super.removeCacheConfigFromLocal(cacheNameWithPrefix);
    }

    public <T> T unwrap(Class<T> clazz) {
        if (HazelcastServerCacheManager.class.isAssignableFrom(clazz)) {
            return (T)this;
        }
        throw new IllegalArgumentException();
    }

    @Override
    protected void postClose() {
        if (this.properties.getProperty("hazelcast.config.location") != null) {
            this.hazelcastInstance.shutdown();
        }
    }

    @Override
    protected void onShuttingDown() {
        this.close();
    }

    public ICacheService getCacheService() {
        return this.cacheService;
    }
}

