/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.spi.impl.operationservice.impl;

import com.hazelcast.instance.Node;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.Packet;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.OperationResponseHandler;
import com.hazelcast.spi.impl.operationservice.impl.responses.ErrorResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.NormalResponse;
import com.hazelcast.spi.impl.operationservice.impl.responses.Response;
import com.hazelcast.util.Preconditions;

public final class OutboundResponseHandler
implements OperationResponseHandler {
    private final Address thisAddress;
    private final InternalSerializationService serializationService;
    private final ILogger logger;
    private final Node node;

    OutboundResponseHandler(Address thisAddress, InternalSerializationService serializationService, Node node, ILogger logger) {
        this.thisAddress = thisAddress;
        this.serializationService = serializationService;
        this.node = node;
        this.logger = logger;
    }

    public void sendResponse(Operation operation, Object obj) {
        Response response = OutboundResponseHandler.toResponse(operation, obj);
        if (!this.send(response, operation.getCallerAddress())) {
            Connection conn = operation.getConnection();
            this.logger.warning("Cannot send response: " + obj + " to " + conn.getEndPoint() + ". " + operation);
        }
    }

    private static Response toResponse(Operation operation, Object obj) {
        if (obj instanceof Throwable) {
            return new ErrorResponse((Throwable)obj, operation.getCallId(), operation.isUrgent());
        }
        if (!(obj instanceof Response)) {
            return new NormalResponse(obj, operation.getCallId(), 0, operation.isUrgent());
        }
        return (Response)obj;
    }

    public boolean send(Response response, Address target) {
        Preconditions.checkNotNull(target, "Target is required!");
        if (this.thisAddress.equals(target)) {
            throw new IllegalArgumentException("Target is this node! -> " + target + ", response: " + response);
        }
        byte[] bytes = this.serializationService.toBytes(response);
        Packet packet = new Packet(bytes, -1).setPacketType(Packet.Type.OPERATION).raiseFlags(2);
        if (response.isUrgent()) {
            packet.raiseFlags(16);
        }
        ConnectionManager connectionManager = this.node.getConnectionManager();
        Connection connection = connectionManager.getOrConnect(target);
        return connectionManager.transmit(packet, connection);
    }
}

