/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.map.impl.querycache.QueryCacheContext;
import com.hazelcast.map.impl.querycache.Registry;
import com.hazelcast.map.impl.querycache.accumulator.Accumulator;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfo;
import com.hazelcast.map.impl.querycache.accumulator.AccumulatorInfoSupplier;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberAccumulatorFactory;
import com.hazelcast.map.impl.querycache.subscriber.SubscriberContext;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import com.hazelcast.util.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class SubscriberRegistry
implements Registry<String, Accumulator> {
    private final ConstructorFunction<String, Accumulator> accumulatorConstructor = new ConstructorFunction<String, Accumulator>(){

        @Override
        public Accumulator createNew(String cacheName) {
            AccumulatorInfo info = SubscriberRegistry.this.getAccumulatorInfo(cacheName);
            Preconditions.checkNotNull(info, "info cannot be null");
            SubscriberAccumulatorFactory accumulatorFactory = SubscriberRegistry.this.createSubscriberAccumulatorFactory();
            return accumulatorFactory.createAccumulator(info);
        }
    };
    private final String mapName;
    private final QueryCacheContext context;
    private final ConcurrentMap<String, Accumulator> accumulators;

    public SubscriberRegistry(QueryCacheContext context, String mapName) {
        this.context = context;
        this.mapName = mapName;
        this.accumulators = new ConcurrentHashMap<String, Accumulator>();
    }

    @Override
    public Accumulator getOrCreate(String cacheName) {
        return ConcurrencyUtil.getOrPutIfAbsent(this.accumulators, cacheName, this.accumulatorConstructor);
    }

    @Override
    public Accumulator getOrNull(String cacheName) {
        return (Accumulator)this.accumulators.get(cacheName);
    }

    @Override
    public Map<String, Accumulator> getAll() {
        return Collections.unmodifiableMap(this.accumulators);
    }

    @Override
    public Accumulator remove(String cacheName) {
        return (Accumulator)this.accumulators.remove(cacheName);
    }

    private AccumulatorInfo getAccumulatorInfo(String cacheName) {
        SubscriberContext subscriberContext = this.context.getSubscriberContext();
        AccumulatorInfoSupplier infoSupplier = subscriberContext.getAccumulatorInfoSupplier();
        return infoSupplier.getAccumulatorInfoOrNull(this.mapName, cacheName);
    }

    protected SubscriberAccumulatorFactory createSubscriberAccumulatorFactory() {
        return new SubscriberAccumulatorFactory(this.context);
    }

    protected QueryCacheContext getContext() {
        return this.context;
    }
}

