/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.operation;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.EntryView;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.HazelcastInstanceAware;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.map.EntryBackupProcessor;
import com.hazelcast.map.impl.EntryViews;
import com.hazelcast.map.impl.LazyMapEntry;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.event.MapEventPublisher;
import com.hazelcast.map.impl.operation.MutatingKeyBasedMapOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.BackupOperation;
import com.hazelcast.spi.serialization.SerializationService;
import com.hazelcast.util.Clock;
import java.io.IOException;
import java.util.Map;

public class EntryBackupOperation
extends MutatingKeyBasedMapOperation
implements BackupOperation {
    protected transient Object oldValue;
    private EntryBackupProcessor entryProcessor;

    public EntryBackupOperation() {
    }

    public EntryBackupOperation(String name, Data dataKey, EntryBackupProcessor entryProcessor) {
        super(name, dataKey);
        this.entryProcessor = entryProcessor;
    }

    @Override
    public void innerBeforeRun() throws Exception {
        super.innerBeforeRun();
        if (this.entryProcessor instanceof HazelcastInstanceAware) {
            HazelcastInstance hazelcastInstance = this.getNodeEngine().getHazelcastInstance();
            ((HazelcastInstanceAware)((Object)this.entryProcessor)).setHazelcastInstance(hazelcastInstance);
        }
    }

    @Override
    public void run() {
        boolean shouldClone = this.mapContainer.shouldCloneOnEntryProcessing();
        SerializationService serializationService = this.getNodeEngine().getSerializationService();
        this.oldValue = this.recordStore.get(this.dataKey, true);
        Object value = shouldClone ? serializationService.toObject(serializationService.toData(this.oldValue)) : this.oldValue;
        Map.Entry entry = this.createMapEntry(this.dataKey, value);
        this.entryProcessor.processBackup(entry);
        if (this.noOpBackup(entry)) {
            return;
        }
        if (this.entryRemovedBackup(entry)) {
            return;
        }
        this.entryAddedOrUpdatedBackup(entry);
    }

    private void publishWanReplicationEvent(EntryEventType eventType) {
        MapContainer mapContainer = this.mapContainer;
        if (!mapContainer.isWanReplicationEnabled()) {
            return;
        }
        MapEventPublisher mapEventPublisher = mapContainer.getMapServiceContext().getMapEventPublisher();
        Data key = this.dataKey;
        if (EntryEventType.REMOVED == eventType) {
            mapEventPublisher.publishWanReplicationRemoveBackup(this.name, key, Clock.currentTimeMillis());
        } else {
            Object record = this.recordStore.getRecord(key);
            if (record != null) {
                this.dataValue = mapContainer.getMapServiceContext().toData(this.dataValue);
                EntryView<Data, Data> entryView = EntryViews.createSimpleEntryView(key, this.dataValue, record);
                mapEventPublisher.publishWanReplicationUpdateBackup(this.name, entryView);
            }
        }
    }

    @Override
    public void afterRun() throws Exception {
        this.evict(this.dataKey);
    }

    private boolean entryRemovedBackup(Map.Entry entry) {
        Object value = entry.getValue();
        if (value == null) {
            this.recordStore.removeBackup(this.dataKey);
            this.publishWanReplicationEvent(EntryEventType.REMOVED);
            return true;
        }
        return false;
    }

    private void entryAddedOrUpdatedBackup(Map.Entry entry) {
        Object value = entry.getValue();
        this.recordStore.putBackup(this.dataKey, value);
        this.publishWanReplicationEvent(EntryEventType.UPDATED);
    }

    private boolean noOpBackup(Map.Entry entry) {
        LazyMapEntry mapEntrySimple = (LazyMapEntry)entry;
        return !mapEntrySimple.isModified() || this.oldValue == null && entry.getValue() == null;
    }

    private Map.Entry createMapEntry(Data key, Object value) {
        InternalSerializationService serializationService = (InternalSerializationService)this.getNodeEngine().getSerializationService();
        return new LazyMapEntry(key, value, serializationService, this.mapContainer.getExtractors());
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.entryProcessor = (EntryBackupProcessor)in.readObject();
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.entryProcessor);
    }

    @Override
    public int getId() {
        return 19;
    }
}

