/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nonblocking.iobalancer;

import com.hazelcast.instance.HazelcastThreadGroup;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.networking.nonblocking.MigratableHandler;
import com.hazelcast.internal.networking.nonblocking.NonBlockingIOThread;
import com.hazelcast.internal.networking.nonblocking.iobalancer.EventCountBasicMigrationStrategy;
import com.hazelcast.internal.networking.nonblocking.iobalancer.IOBalancerThread;
import com.hazelcast.internal.networking.nonblocking.iobalancer.LoadImbalance;
import com.hazelcast.internal.networking.nonblocking.iobalancer.LoadTracker;
import com.hazelcast.internal.networking.nonblocking.iobalancer.MigrationStrategy;
import com.hazelcast.internal.networking.nonblocking.iobalancer.MonkeyMigrationStrategy;
import com.hazelcast.internal.util.counters.MwCounter;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.spi.properties.GroupProperty;

public class IOBalancer {
    private static final String PROP_MONKEY_BALANCER = "hazelcast.io.balancer.monkey";
    private final ILogger logger;
    private final int balancerIntervalSeconds;
    private final MigrationStrategy strategy;
    private final LoadTracker inLoadTracker;
    private final LoadTracker outLoadTracker;
    private final HazelcastThreadGroup threadGroup;
    private volatile boolean enabled;
    private IOBalancerThread ioBalancerThread;
    @Probe
    private final SwCounter imbalanceDetectedCount = SwCounter.newSwCounter();
    @Probe
    private final MwCounter migrationCompletedCount = MwCounter.newMwCounter();

    public IOBalancer(NonBlockingIOThread[] inputThreads, NonBlockingIOThread[] outputThreads, HazelcastThreadGroup threadGroup, int balancerIntervalSeconds, LoggingService loggingService) {
        this.logger = loggingService.getLogger(IOBalancer.class);
        this.balancerIntervalSeconds = balancerIntervalSeconds;
        this.strategy = this.createMigrationStrategy();
        this.threadGroup = threadGroup;
        this.inLoadTracker = new LoadTracker(inputThreads, this.logger);
        this.outLoadTracker = new LoadTracker(outputThreads, this.logger);
        this.enabled = this.isEnabled(inputThreads, outputThreads);
    }

    LoadTracker getInLoadTracker() {
        return this.inLoadTracker;
    }

    LoadTracker getOutLoadTracker() {
        return this.outLoadTracker;
    }

    public void connectionAdded(MigratableHandler readHandler, MigratableHandler writeHandler) {
        this.inLoadTracker.notifyHandlerAdded(readHandler);
        this.outLoadTracker.notifyHandlerAdded(writeHandler);
    }

    public void connectionRemoved(MigratableHandler readHandler, MigratableHandler writeHandler) {
        this.inLoadTracker.notifyHandlerRemoved(readHandler);
        this.outLoadTracker.notifyHandlerRemoved(writeHandler);
    }

    public void start() {
        if (this.enabled) {
            this.ioBalancerThread = new IOBalancerThread(this, this.balancerIntervalSeconds, this.threadGroup, this.logger);
            this.ioBalancerThread.start();
        }
    }

    public void stop() {
        if (this.ioBalancerThread != null) {
            this.ioBalancerThread.shutdown();
        }
    }

    void checkWriteHandlers() {
        this.scheduleMigrationIfNeeded(this.outLoadTracker);
    }

    void checkReadHandlers() {
        this.scheduleMigrationIfNeeded(this.inLoadTracker);
    }

    private void scheduleMigrationIfNeeded(LoadTracker loadTracker) {
        LoadImbalance loadImbalance = loadTracker.updateImbalance();
        if (this.strategy.imbalanceDetected(loadImbalance)) {
            this.imbalanceDetectedCount.inc();
            this.tryMigrate(loadImbalance);
        } else if (this.logger.isFinestEnabled()) {
            long min = loadImbalance.minimumEvents;
            long max = loadImbalance.maximumEvents;
            this.logger.finest("No imbalance has been detected. Max. events: " + max + " Min events: " + min + ".");
        }
    }

    private MigrationStrategy createMigrationStrategy() {
        if (Boolean.getBoolean(PROP_MONKEY_BALANCER)) {
            this.logger.warning("Using Monkey IO Balancer Strategy. This is for stress tests only. Do not user in production! Disable by not setting the property 'hazelcast.io.balancer.monkey' to true.");
            return new MonkeyMigrationStrategy();
        }
        this.logger.finest("Using normal IO Balancer Strategy.");
        return new EventCountBasicMigrationStrategy();
    }

    private boolean isEnabled(NonBlockingIOThread[] inputThreads, NonBlockingIOThread[] outputThreads) {
        if (this.balancerIntervalSeconds <= 0) {
            this.logger.warning("I/O Balancer is disabled as the '" + GroupProperty.IO_BALANCER_INTERVAL_SECONDS + "' property is set to " + this.balancerIntervalSeconds + ". Set the property to a value larger than 0 to enable the I/O Balancer.");
            return false;
        }
        if (inputThreads.length == 1 && outputThreads.length == 1) {
            this.logger.finest("I/O Balancer is disabled as there is only a single a pair of I/O threads. Use the '" + GroupProperty.IO_THREAD_COUNT + "' property to increase number of I/O Threads.");
            return false;
        }
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("I/O Balancer is enabled. Scanning every " + this.balancerIntervalSeconds + " seconds for imbalances.");
        }
        return true;
    }

    private void tryMigrate(LoadImbalance loadImbalance) {
        MigratableHandler handler = this.strategy.findHandlerToMigrate(loadImbalance);
        if (handler == null) {
            this.logger.finest("I/O imbalance is detected, but no suitable migration candidate is found.");
            return;
        }
        NonBlockingIOThread destinationSelector = loadImbalance.destinationSelector;
        if (this.logger.isFinestEnabled()) {
            NonBlockingIOThread sourceSelector = loadImbalance.sourceSelector;
            this.logger.finest("Scheduling migration of handler " + handler + " from selector thread " + sourceSelector + " to " + destinationSelector);
        }
        handler.requestMigration(destinationSelector);
    }

    public void signalMigrationComplete() {
        this.migrationCompletedCount.inc();
    }
}

