/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nonblocking;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.SocketConnection;
import com.hazelcast.internal.networking.SocketWriter;
import com.hazelcast.internal.networking.SocketWriterInitializer;
import com.hazelcast.internal.networking.WriteHandler;
import com.hazelcast.internal.networking.nonblocking.AbstractHandler;
import com.hazelcast.internal.networking.nonblocking.NonBlockingIOThread;
import com.hazelcast.internal.networking.nonblocking.iobalancer.IOBalancer;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.nio.Packet;
import com.hazelcast.util.EmptyStatement;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

public final class NonBlockingSocketWriter
extends AbstractHandler
implements Runnable,
SocketWriter {
    private static final long TIMEOUT = 3L;
    @Probe(name="writeQueueSize")
    public final Queue<OutboundFrame> writeQueue = new ConcurrentLinkedQueue<OutboundFrame>();
    @Probe(name="priorityWriteQueueSize")
    public final Queue<OutboundFrame> urgentWriteQueue = new ConcurrentLinkedQueue<OutboundFrame>();
    private final SocketWriterInitializer initializer;
    private ByteBuffer outputBuffer;
    private final AtomicBoolean scheduled = new AtomicBoolean(false);
    @Probe(name="bytesWritten")
    private final SwCounter bytesWritten = SwCounter.newSwCounter();
    @Probe(name="normalFramesWritten")
    private final SwCounter normalFramesWritten = SwCounter.newSwCounter();
    @Probe(name="priorityFramesWritten")
    private final SwCounter priorityFramesWritten = SwCounter.newSwCounter();
    private WriteHandler writeHandler;
    private volatile OutboundFrame currentFrame;
    private volatile long lastWriteTime;
    private NonBlockingIOThread newOwner;

    public NonBlockingSocketWriter(SocketConnection connection, NonBlockingIOThread ioThread, ILogger logger, IOBalancer balancer, SocketWriterInitializer initializer) {
        super(connection, ioThread, 4, logger, balancer);
        this.initializer = initializer;
    }

    @Override
    public int totalFramesPending() {
        return this.writeQueue.size() + this.urgentWriteQueue.size();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.lastWriteTime;
    }

    @Override
    public WriteHandler getWriteHandler() {
        return this.writeHandler;
    }

    @Probe(name="writeQueuePendingBytes", level=ProbeLevel.DEBUG)
    public long bytesPending() {
        return this.bytesPending(this.writeQueue);
    }

    @Probe(name="priorityWriteQueuePendingBytes", level=ProbeLevel.DEBUG)
    public long priorityBytesPending() {
        return this.bytesPending(this.urgentWriteQueue);
    }

    private long bytesPending(Queue<OutboundFrame> writeQueue) {
        long bytesPending = 0L;
        for (OutboundFrame frame : writeQueue) {
            if (!(frame instanceof Packet)) continue;
            bytesPending += (long)((Packet)frame).packetSize();
        }
        return bytesPending;
    }

    @Probe(name="idleTimeMs")
    private long idleTimeMs() {
        return Math.max(System.currentTimeMillis() - this.lastWriteTime, 0L);
    }

    @Probe(name="isScheduled", level=ProbeLevel.DEBUG)
    private long isScheduled() {
        return this.scheduled.get() ? 1L : 0L;
    }

    @Override
    public void setProtocol(final String protocol) {
        final CountDownLatch latch = new CountDownLatch(1);
        this.ioThread.addTaskAndWakeup(new Runnable(){

            @Override
            public void run() {
                try {
                    if (NonBlockingSocketWriter.this.writeHandler == null) {
                        NonBlockingSocketWriter.this.initializer.init(NonBlockingSocketWriter.this.connection, NonBlockingSocketWriter.this, protocol);
                    }
                }
                catch (Throwable t) {
                    NonBlockingSocketWriter.this.onFailure(t);
                }
                finally {
                    latch.countDown();
                }
            }
        });
        try {
            latch.await(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            this.logger.finest("CountDownLatch::await interrupted", e);
        }
    }

    @Override
    public void initOutputBuffer(ByteBuffer outputBuffer) {
        this.outputBuffer = outputBuffer;
    }

    @Override
    public void write(OutboundFrame frame) {
        if (frame.isUrgent()) {
            this.urgentWriteQueue.offer(frame);
        } else {
            this.writeQueue.offer(frame);
        }
        this.schedule();
    }

    private OutboundFrame poll() {
        OutboundFrame frame;
        boolean urgent;
        while (true) {
            urgent = true;
            frame = this.urgentWriteQueue.poll();
            if (frame == null) {
                urgent = false;
                frame = this.writeQueue.poll();
            }
            if (frame == null) {
                return null;
            }
            if (frame.getClass() != TaskFrame.class) break;
            TaskFrame taskFrame = (TaskFrame)frame;
            taskFrame.task.run();
        }
        if (urgent) {
            this.priorityFramesWritten.inc();
        } else {
            this.normalFramesWritten.inc();
        }
        return frame;
    }

    private void schedule() {
        if (this.scheduled.get()) {
            return;
        }
        if (!this.scheduled.compareAndSet(false, true)) {
            return;
        }
        this.ioThread.addTaskAndWakeup(this);
    }

    private void unschedule() throws IOException {
        if (this.dirtyOutputBuffer() || this.currentFrame != null) {
            this.registerOp(4);
            return;
        }
        this.unregisterOp(4);
        this.scheduled.set(false);
        if (this.writeQueue.isEmpty() && this.urgentWriteQueue.isEmpty()) {
            return;
        }
        if (!this.scheduled.compareAndSet(false, true)) {
            return;
        }
        this.ioThread.addTask(this);
    }

    @Override
    public void handle() throws Exception {
        this.eventCount.inc();
        this.lastWriteTime = System.currentTimeMillis();
        if (this.writeHandler == null) {
            this.initializer.init(this.connection, this, "HZC");
            this.registerOp(4);
        }
        this.fillOutputBuffer();
        if (this.dirtyOutputBuffer()) {
            this.writeOutputBufferToSocket();
        }
        if (this.newOwner == null) {
            this.unschedule();
        } else {
            this.startMigration();
        }
    }

    @Override
    public void initWriteHandler(WriteHandler writeHandler) {
        this.writeHandler = writeHandler;
    }

    private void startMigration() throws IOException {
        NonBlockingIOThread newOwner = this.newOwner;
        this.newOwner = null;
        this.startMigration(newOwner);
    }

    private boolean dirtyOutputBuffer() {
        return this.outputBuffer.position() > 0;
    }

    private void writeOutputBufferToSocket() throws IOException {
        this.outputBuffer.flip();
        int written = this.socketChannel.write(this.outputBuffer);
        this.bytesWritten.inc(written);
        if (this.outputBuffer.hasRemaining()) {
            this.outputBuffer.compact();
        } else {
            this.outputBuffer.clear();
        }
    }

    private void fillOutputBuffer() throws Exception {
        while (this.outputBuffer.hasRemaining()) {
            if (this.currentFrame == null) {
                this.currentFrame = this.poll();
                if (this.currentFrame == null) {
                    return;
                }
            }
            if (!this.writeHandler.onWrite(this.currentFrame, this.outputBuffer)) {
                return;
            }
            this.currentFrame = null;
        }
        return;
    }

    @Override
    public void run() {
        try {
            this.handle();
        }
        catch (Throwable t) {
            this.onFailure(t);
        }
    }

    @Override
    public void close() {
        this.writeQueue.clear();
        this.urgentWriteQueue.clear();
        CloseTask closeTask = new CloseTask();
        this.write(new TaskFrame(closeTask));
        closeTask.awaitCompletion();
    }

    @Override
    public void requestMigration(NonBlockingIOThread newOwner) {
        this.write(new TaskFrame(new StartMigrationTask(newOwner)));
    }

    public String toString() {
        return this.connection + ".socketWriter";
    }

    private class CloseTask
    implements Runnable {
        private final CountDownLatch latch = new CountDownLatch(1);

        private CloseTask() {
        }

        @Override
        public void run() {
            try {
                NonBlockingSocketWriter.this.socketChannel.closeOutbound();
            }
            catch (IOException e) {
                NonBlockingSocketWriter.this.logger.finest("Error while closing outbound", e);
            }
            finally {
                this.latch.countDown();
            }
        }

        void awaitCompletion() {
            try {
                this.latch.await(3L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                EmptyStatement.ignore(e);
            }
        }
    }

    private final class StartMigrationTask
    implements Runnable {
        private final NonBlockingIOThread theNewOwner;

        StartMigrationTask(NonBlockingIOThread theNewOwner) {
            this.theNewOwner = theNewOwner;
        }

        @Override
        public void run() {
            assert (NonBlockingSocketWriter.this.newOwner == null) : "No migration can be in progress";
            if (NonBlockingSocketWriter.this.ioThread == this.theNewOwner) {
                return;
            }
            NonBlockingSocketWriter.this.newOwner = this.theNewOwner;
        }
    }

    private static final class TaskFrame
    implements OutboundFrame {
        private final Runnable task;

        private TaskFrame(Runnable task) {
            this.task = task;
        }

        @Override
        public boolean isUrgent() {
            return true;
        }
    }
}

