/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl;

import com.hazelcast.core.ManagedContext;
import com.hazelcast.core.PartitioningStrategy;
import com.hazelcast.internal.serialization.InputOutputFactory;
import com.hazelcast.internal.serialization.PortableContext;
import com.hazelcast.internal.serialization.impl.AbstractSerializationService;
import com.hazelcast.internal.serialization.impl.ArrayListStreamSerializer;
import com.hazelcast.internal.serialization.impl.ConstantSerializers;
import com.hazelcast.internal.serialization.impl.DataSerializableSerializer;
import com.hazelcast.internal.serialization.impl.JavaDefaultSerializers;
import com.hazelcast.internal.serialization.impl.LinkedListStreamSerializer;
import com.hazelcast.internal.serialization.impl.PortableContextImpl;
import com.hazelcast.internal.serialization.impl.PortableHookLoader;
import com.hazelcast.internal.serialization.impl.PortableSerializer;
import com.hazelcast.internal.serialization.impl.SerializationUtil;
import com.hazelcast.internal.serialization.impl.bufferpool.BufferPoolFactory;
import com.hazelcast.nio.BufferObjectDataInput;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.DataSerializable;
import com.hazelcast.nio.serialization.DataSerializableFactory;
import com.hazelcast.nio.serialization.FieldDefinition;
import com.hazelcast.nio.serialization.FieldType;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.Portable;
import com.hazelcast.nio.serialization.PortableFactory;
import com.hazelcast.nio.serialization.PortableReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class SerializationServiceV1
extends AbstractSerializationService {
    private static final int FACTORY_AND_CLASS_ID_BYTE_LENGTH = 8;
    private static final int EE_BYTE_LENGTH = 2;
    private final PortableContextImpl portableContext;
    private final PortableSerializer portableSerializer;

    SerializationServiceV1(InputOutputFactory inputOutputFactory, byte version, int portableVersion, ClassLoader classLoader, Map<Integer, ? extends DataSerializableFactory> dataSerializableFactories, Map<Integer, ? extends PortableFactory> portableFactories, ManagedContext managedContext, PartitioningStrategy globalPartitionStrategy, int initialOutputBufferSize, BufferPoolFactory bufferPoolFactory, boolean enableCompression, boolean enableSharedObject) {
        super(inputOutputFactory, version, classLoader, managedContext, globalPartitionStrategy, initialOutputBufferSize, bufferPoolFactory);
        PortableHookLoader loader = new PortableHookLoader(portableFactories, classLoader);
        this.portableContext = new PortableContextImpl(this, portableVersion);
        for (ClassDefinition cd : loader.getDefinitions()) {
            this.portableContext.registerClassDefinition(cd);
        }
        this.dataSerializerAdapter = SerializationUtil.createSerializerAdapter(new DataSerializableSerializer(dataSerializableFactories, classLoader), this);
        this.portableSerializer = new PortableSerializer(this.portableContext, loader.getFactories());
        this.portableSerializerAdapter = SerializationUtil.createSerializerAdapter(this.portableSerializer, this);
        this.javaSerializerAdapter = SerializationUtil.createSerializerAdapter(new JavaDefaultSerializers.JavaSerializer(enableSharedObject, enableCompression), this);
        this.javaExternalizableAdapter = SerializationUtil.createSerializerAdapter(new JavaDefaultSerializers.ExternalizableSerializer(enableCompression), this);
        this.registerConstantSerializers();
        this.registerJavaTypeSerializers();
    }

    @Override
    public PortableReader createPortableReader(Data data) throws IOException {
        if (!data.isPortable()) {
            throw new IllegalArgumentException("Given data is not Portable! -> " + data.getType());
        }
        BufferObjectDataInput in = this.createObjectDataInput(data);
        return this.portableSerializer.createReader(in);
    }

    @Override
    public PortableContext getPortableContext() {
        return this.portableContext;
    }

    private void registerConstantSerializers() {
        this.registerConstant(null, this.nullSerializerAdapter);
        this.registerConstant(DataSerializable.class, this.dataSerializerAdapter);
        this.registerConstant(Portable.class, this.portableSerializerAdapter);
        this.registerConstant(Byte.class, new ConstantSerializers.ByteSerializer());
        this.registerConstant(Boolean.class, new ConstantSerializers.BooleanSerializer());
        this.registerConstant(Character.class, new ConstantSerializers.CharSerializer());
        this.registerConstant(Short.class, new ConstantSerializers.ShortSerializer());
        this.registerConstant(Integer.class, new ConstantSerializers.IntegerSerializer());
        this.registerConstant(Long.class, new ConstantSerializers.LongSerializer());
        this.registerConstant(Float.class, new ConstantSerializers.FloatSerializer());
        this.registerConstant(Double.class, new ConstantSerializers.DoubleSerializer());
        this.registerConstant(String.class, new ConstantSerializers.StringSerializer());
        this.registerConstant(byte[].class, new ConstantSerializers.TheByteArraySerializer());
        this.registerConstant(boolean[].class, new ConstantSerializers.BooleanArraySerializer());
        this.registerConstant(char[].class, new ConstantSerializers.CharArraySerializer());
        this.registerConstant(short[].class, new ConstantSerializers.ShortArraySerializer());
        this.registerConstant(int[].class, new ConstantSerializers.IntegerArraySerializer());
        this.registerConstant(long[].class, new ConstantSerializers.LongArraySerializer());
        this.registerConstant(float[].class, new ConstantSerializers.FloatArraySerializer());
        this.registerConstant(double[].class, new ConstantSerializers.DoubleArraySerializer());
        this.registerConstant(String[].class, new ConstantSerializers.StringArraySerializer());
    }

    private void registerJavaTypeSerializers() {
        this.registerConstant(Date.class, new JavaDefaultSerializers.DateSerializer());
        this.registerConstant(BigInteger.class, new JavaDefaultSerializers.BigIntegerSerializer());
        this.registerConstant(BigDecimal.class, new JavaDefaultSerializers.BigDecimalSerializer());
        this.registerConstant(Class.class, new JavaDefaultSerializers.ClassSerializer());
        this.registerConstant(Enum.class, new JavaDefaultSerializers.EnumSerializer());
        this.registerConstant(ArrayList.class, new ArrayListStreamSerializer());
        this.registerConstant(LinkedList.class, new LinkedListStreamSerializer());
        this.safeRegister(Serializable.class, this.javaSerializerAdapter);
        this.safeRegister(Externalizable.class, this.javaExternalizableAdapter);
    }

    public void registerClassDefinitions(Collection<ClassDefinition> classDefinitions, boolean checkClassDefErrors) {
        HashMap<Integer, ClassDefinition> classDefMap = new HashMap<Integer, ClassDefinition>(classDefinitions.size());
        for (ClassDefinition cd : classDefinitions) {
            if (classDefMap.containsKey(cd.getClassId())) {
                throw new HazelcastSerializationException("Duplicate registration found for class-id[" + cd.getClassId() + "]!");
            }
            classDefMap.put(cd.getClassId(), cd);
        }
        for (ClassDefinition classDefinition : classDefinitions) {
            this.registerClassDefinition(classDefinition, classDefMap, checkClassDefErrors);
        }
    }

    protected void registerClassDefinition(ClassDefinition cd, Map<Integer, ClassDefinition> classDefMap, boolean checkClassDefErrors) {
        Set<String> fieldNames = cd.getFieldNames();
        for (String fieldName : fieldNames) {
            FieldDefinition fd = cd.getField(fieldName);
            if (fd.getType() != FieldType.PORTABLE && fd.getType() != FieldType.PORTABLE_ARRAY) continue;
            int classId = fd.getClassId();
            ClassDefinition nestedCd = classDefMap.get(classId);
            if (nestedCd != null) {
                this.registerClassDefinition(nestedCd, classDefMap, checkClassDefErrors);
                this.portableContext.registerClassDefinition(nestedCd);
                continue;
            }
            if (!checkClassDefErrors) continue;
            throw new HazelcastSerializationException("Could not find registered ClassDefinition for class-id: " + classId);
        }
        this.portableContext.registerClassDefinition(cd);
    }

    final PortableSerializer getPortableSerializer() {
        return this.portableSerializer;
    }

    public ObjectDataInput initDataSerializableInputAndSkipTheHeader(Data data) throws IOException {
        BufferObjectDataInput input = this.createObjectDataInput(data);
        byte header = input.readByte();
        if (DataSerializableSerializer.isFlagSet(header, (byte)1)) {
            this.skipBytesSafely(input, 8);
        } else {
            input.readUTF();
        }
        if (DataSerializableSerializer.isFlagSet(header, (byte)2)) {
            this.skipBytesSafely(input, 2);
        }
        return input;
    }

    private void skipBytesSafely(ObjectDataInput input, int count) throws IOException {
        if (input.skipBytes(count) != count) {
            throw new HazelcastSerializationException("Malformed serialization format");
        }
    }
}

