/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.query;

import com.hazelcast.config.CacheDeserializedValues;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.serialization.InternalSerializationService;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.MapContainer;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.PartitionContainer;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.record.Records;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.PagingPredicate;
import com.hazelcast.query.PagingPredicateAccessor;
import com.hazelcast.query.Predicate;
import com.hazelcast.query.impl.CachedQueryEntry;
import com.hazelcast.query.impl.QueryableEntry;
import com.hazelcast.query.impl.getters.Extractors;
import com.hazelcast.spi.NodeEngine;
import com.hazelcast.spi.OperationService;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.Clock;
import com.hazelcast.util.SortingUtil;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

public class PartitionScanRunner {
    protected final MapServiceContext mapServiceContext;
    protected final NodeEngine nodeEngine;
    protected final ILogger logger;
    protected final InternalSerializationService serializationService;
    protected final IPartitionService partitionService;
    protected final OperationService operationService;
    protected final ClusterService clusterService;

    public PartitionScanRunner(MapServiceContext mapServiceContext) {
        this.mapServiceContext = mapServiceContext;
        this.nodeEngine = mapServiceContext.getNodeEngine();
        this.serializationService = (InternalSerializationService)this.nodeEngine.getSerializationService();
        this.partitionService = this.nodeEngine.getPartitionService();
        this.logger = this.nodeEngine.getLogger(this.getClass());
        this.operationService = this.nodeEngine.getOperationService();
        this.clusterService = this.nodeEngine.getClusterService();
    }

    public Collection<QueryableEntry> run(String mapName, Predicate predicate, int partitionId) {
        PagingPredicate pagingPredicate = predicate instanceof PagingPredicate ? (PagingPredicate)predicate : null;
        LinkedList<QueryableEntry> resultList = new LinkedList<QueryableEntry>();
        PartitionContainer partitionContainer = this.mapServiceContext.getPartitionContainer(partitionId);
        MapContainer mapContainer = this.mapServiceContext.getMapContainer(mapName);
        Iterator<Record> iterator = partitionContainer.getRecordStore(mapName).loadAwareIterator(this.getNow(), false);
        Map.Entry<Integer, Map.Entry> nearestAnchorEntry = PagingPredicateAccessor.getNearestAnchorEntry(pagingPredicate);
        boolean useCachedValues = this.isUseCachedDeserializedValuesEnabled(mapContainer);
        Extractors extractors = this.mapServiceContext.getExtractors(mapName);
        while (iterator.hasNext()) {
            CachedQueryEntry queryEntry;
            Record record = iterator.next();
            Data key = (Data)this.toData(record.getKey());
            Object value = this.toData(useCachedValues ? Records.getValueOrCachedValue(record, this.serializationService) : record.getValue());
            if (value == null || !predicate.apply(queryEntry = new CachedQueryEntry(this.serializationService, key, value, extractors)) || !SortingUtil.compareAnchor(pagingPredicate, queryEntry, nearestAnchorEntry)) continue;
            resultList.add(queryEntry);
        }
        return SortingUtil.getSortedSubList(resultList, pagingPredicate, nearestAnchorEntry);
    }

    protected boolean isUseCachedDeserializedValuesEnabled(MapContainer mapContainer) {
        CacheDeserializedValues cacheDeserializedValues = mapContainer.getMapConfig().getCacheDeserializedValues();
        switch (cacheDeserializedValues) {
            case NEVER: {
                return false;
            }
            case ALWAYS: {
                return true;
            }
        }
        return mapContainer.getIndexes().hasIndex();
    }

    protected <T> Object toData(T input) {
        return input;
    }

    protected long getNow() {
        return Clock.currentTimeMillis();
    }
}

