/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util.executor;

import com.hazelcast.logging.ILogger;
import com.hazelcast.util.Preconditions;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class LoggingScheduledExecutor
extends ScheduledThreadPoolExecutor {
    private final ILogger logger;
    private volatile boolean shutdownInitiated;

    public LoggingScheduledExecutor(ILogger logger, int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
        this.logger = Preconditions.checkNotNull(logger, "logger cannot be null");
    }

    public LoggingScheduledExecutor(ILogger logger, int corePoolSize, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, threadFactory, handler);
        this.logger = Preconditions.checkNotNull(logger, "logger cannot be null");
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return new LoggingDelegatingFuture<V>(runnable, task);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return new LoggingDelegatingFuture<V>(callable, task);
    }

    @Override
    protected void afterExecute(Runnable runnable, Throwable throwable) {
        super.afterExecute(runnable, throwable);
        Level level = Level.FINE;
        if (throwable == null && runnable instanceof ScheduledFuture && ((ScheduledFuture)((Object)runnable)).isDone()) {
            try {
                ((Future)((Object)runnable)).get();
            }
            catch (CancellationException ce) {
                throwable = ce;
            }
            catch (ExecutionException ee) {
                level = Level.SEVERE;
                throwable = ee.getCause();
            }
            catch (InterruptedException ie) {
                throwable = ie;
                Thread.currentThread().interrupt();
            }
        }
        if (throwable instanceof RejectedExecutionException && this.shutdownInitiated) {
            level = Level.FINE;
        }
        if (throwable != null) {
            this.logger.log(level, "Failed to execute " + runnable, throwable);
        }
    }

    public void notifyShutdownInitiated() {
        this.shutdownInitiated = true;
    }

    static class LoggingDelegatingFuture<V>
    implements RunnableScheduledFuture<V> {
        private final Object task;
        private final RunnableScheduledFuture<V> delegate;

        LoggingDelegatingFuture(Object task, RunnableScheduledFuture<V> delegate) {
            this.task = task;
            this.delegate = delegate;
        }

        @Override
        public boolean isPeriodic() {
            return this.delegate.isPeriodic();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.delegate.getDelay(unit);
        }

        @Override
        public void run() {
            this.delegate.run();
        }

        @Override
        public int compareTo(Delayed o) {
            return this.delegate.compareTo(o);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof LoggingDelegatingFuture)) {
                return false;
            }
            LoggingDelegatingFuture that = (LoggingDelegatingFuture)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.delegate.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.delegate.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.delegate.get(timeout, unit);
        }

        public String toString() {
            return "LoggingDelegatingFuture{task=" + this.task + '}';
        }
    }
}

