/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.querycache.subscriber;

import com.hazelcast.config.EvictionConfig;
import com.hazelcast.config.QueryCacheConfig;
import com.hazelcast.internal.config.ConfigValidator;
import com.hazelcast.internal.eviction.EvictionChecker;
import com.hazelcast.internal.eviction.EvictionListener;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluator;
import com.hazelcast.internal.eviction.EvictionPolicyEvaluatorProvider;
import com.hazelcast.internal.eviction.EvictionStrategy;
import com.hazelcast.internal.eviction.EvictionStrategyProvider;
import com.hazelcast.internal.eviction.MaxSizeChecker;
import com.hazelcast.map.impl.querycache.subscriber.QueryCacheRecordHashMap;
import com.hazelcast.map.impl.querycache.subscriber.record.QueryCacheRecord;
import com.hazelcast.nio.serialization.Data;

public class EvictionOperator {
    private final QueryCacheRecordHashMap cache;
    private final EvictionConfig evictionConfig;
    private final MaxSizeChecker maxSizeChecker;
    private final EvictionPolicyEvaluator<Data, QueryCacheRecord> evictionPolicyEvaluator;
    private final EvictionChecker evictionChecker;
    private final EvictionStrategy<Data, QueryCacheRecord, QueryCacheRecordHashMap> evictionStrategy;
    private final EvictionListener<Data, QueryCacheRecord> listener;
    private final ClassLoader classLoader;

    public EvictionOperator(QueryCacheRecordHashMap cache, QueryCacheConfig config, EvictionListener<Data, QueryCacheRecord> listener, ClassLoader classLoader) {
        this.cache = cache;
        this.evictionConfig = config.getEvictionConfig();
        this.maxSizeChecker = this.createCacheMaxSizeChecker();
        this.evictionPolicyEvaluator = this.createEvictionPolicyEvaluator();
        this.evictionChecker = this.createEvictionChecker();
        this.evictionStrategy = this.createEvictionStrategy();
        this.listener = listener;
        this.classLoader = classLoader;
    }

    boolean isEvictionEnabled() {
        return this.evictionStrategy != null && this.evictionPolicyEvaluator != null;
    }

    int evictIfRequired() {
        int evictedCount = 0;
        if (this.isEvictionEnabled()) {
            evictedCount = this.evictionStrategy.evict(this.cache, this.evictionPolicyEvaluator, this.evictionChecker, this.listener);
        }
        return evictedCount;
    }

    private MaxSizeChecker createCacheMaxSizeChecker() {
        return new MaxSizeChecker(){

            @Override
            public boolean isReachedToMaxSize() {
                return EvictionOperator.this.cache.size() > EvictionOperator.this.evictionConfig.getSize();
            }
        };
    }

    private EvictionPolicyEvaluator<Data, QueryCacheRecord> createEvictionPolicyEvaluator() {
        ConfigValidator.checkEvictionConfig(this.evictionConfig, false);
        return EvictionPolicyEvaluatorProvider.getEvictionPolicyEvaluator(this.evictionConfig, this.classLoader);
    }

    private EvictionStrategy<Data, QueryCacheRecord, QueryCacheRecordHashMap> createEvictionStrategy() {
        return EvictionStrategyProvider.getEvictionStrategy(this.evictionConfig);
    }

    private EvictionChecker createEvictionChecker() {
        return new MaxSizeEvictionChecker();
    }

    private class MaxSizeEvictionChecker
    implements EvictionChecker {
        private MaxSizeEvictionChecker() {
        }

        @Override
        public boolean isEvictionRequired() {
            return EvictionOperator.this.maxSizeChecker != null && EvictionOperator.this.maxSizeChecker.isReachedToMaxSize();
        }
    }
}

