/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache.invalidation;

import com.hazelcast.client.impl.protocol.task.map.MapAssignAndGetUuidsOperationFactory;
import com.hazelcast.cluster.memberselector.MemberSelectors;
import com.hazelcast.core.Member;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataFetcher;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.logging.ILogger;
import com.hazelcast.map.impl.operation.MapGetInvalidationMetaDataOperation;
import com.hazelcast.nio.Address;
import com.hazelcast.spi.InternalCompletableFuture;
import com.hazelcast.spi.OperationService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.logging.Level;

public class MemberMapMetaDataFetcher
extends MetaDataFetcher {
    private final ClusterService clusterService;
    private final OperationService operationService;

    public MemberMapMetaDataFetcher(ClusterService clusterService, OperationService operationService, ILogger logger) {
        super(logger);
        this.clusterService = clusterService;
        this.operationService = operationService;
    }

    @Override
    protected List<InternalCompletableFuture> scanMembers(List<String> names) {
        Collection<Member> members = this.clusterService.getMembers(MemberSelectors.DATA_MEMBER_SELECTOR);
        ArrayList<InternalCompletableFuture> futures = new ArrayList<InternalCompletableFuture>(members.size());
        for (Member member : members) {
            MapGetInvalidationMetaDataOperation operation = new MapGetInvalidationMetaDataOperation(names);
            Address address = member.getAddress();
            try {
                futures.add(this.operationService.invokeOnTarget("hz:impl:mapService", operation, address));
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.WARNING)) continue;
                this.logger.log(Level.WARNING, "Cant fetch invalidation meta-data from address + " + address + " + [" + e.getMessage() + "]");
            }
        }
        return futures;
    }

    @Override
    protected void process(InternalCompletableFuture future, ConcurrentMap<String, RepairingHandler> handlers) {
        block2: {
            try {
                MapGetInvalidationMetaDataOperation.MetaDataResponse response = this.extractResponse(future);
                this.repairUuids(response.getPartitionUuidList(), handlers);
                this.repairSequences(response.getNamePartitionSequenceList(), handlers);
            }
            catch (Exception e) {
                if (!this.logger.isLoggable(Level.WARNING)) break block2;
                this.logger.log(Level.WARNING, "Cant fetch invalidation meta-data [" + e.getMessage() + "]");
            }
        }
    }

    private MapGetInvalidationMetaDataOperation.MetaDataResponse extractResponse(InternalCompletableFuture future) throws InterruptedException, ExecutionException, TimeoutException {
        return (MapGetInvalidationMetaDataOperation.MetaDataResponse)future.get(1L, TimeUnit.MINUTES);
    }

    @Override
    public List<Object> assignAndGetUuids() throws Exception {
        MapAssignAndGetUuidsOperationFactory factory = new MapAssignAndGetUuidsOperationFactory();
        Map<Integer, Object> results = this.operationService.invokeOnAllPartitions("hz:impl:mapService", factory);
        ArrayList<Object> objects = new ArrayList<Object>(2 * results.size());
        for (Map.Entry<Integer, Object> entry : results.entrySet()) {
            objects.add(entry.getKey());
            objects.add(entry.getValue());
        }
        return objects;
    }
}

