/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.map.impl.nearcache.KeyStateMarker;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.util.HashUtil;
import java.util.concurrent.atomic.AtomicIntegerArray;

public class KeyStateMarkerImpl
implements KeyStateMarker {
    private final AtomicIntegerArray marks;

    public KeyStateMarkerImpl(int markerCount) {
        this.marks = new AtomicIntegerArray(markerCount);
    }

    @Override
    public boolean markIfUnmarked(Object key) {
        return this.casState(key, KeyStateMarker.STATE.UNMARKED, KeyStateMarker.STATE.MARKED);
    }

    @Override
    public boolean unmarkIfMarked(Object key) {
        return this.casState(key, KeyStateMarker.STATE.MARKED, KeyStateMarker.STATE.UNMARKED);
    }

    @Override
    public boolean removeIfMarked(Object key) {
        return this.casState(key, KeyStateMarker.STATE.MARKED, KeyStateMarker.STATE.REMOVED);
    }

    @Override
    public void unmarkForcibly(Object key) {
        int slot = this.getSlot(key);
        this.marks.set(slot, KeyStateMarker.STATE.UNMARKED.getState());
    }

    @Override
    public void unmarkAllForcibly() {
        int slot = 0;
        do {
            this.marks.set(slot, KeyStateMarker.STATE.UNMARKED.getState());
        } while (++slot < this.marks.length());
    }

    private boolean casState(Object key, KeyStateMarker.STATE expect, KeyStateMarker.STATE update) {
        int slot = this.getSlot(key);
        return this.marks.compareAndSet(slot, expect.getState(), update.getState());
    }

    private int getSlot(Object key) {
        int hash = key instanceof Data ? ((Data)key).getPartitionHash() : key.hashCode();
        return HashUtil.hashToIndex(hash, this.marks.length());
    }

    public AtomicIntegerArray getMarks() {
        return this.marks;
    }

    public String toString() {
        return "KeyStateMarkerImpl{markerCount=" + this.marks.length() + ", marks=" + this.marks + '}';
    }
}

