/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.EntryView;
import com.hazelcast.map.impl.LazyEntryView;
import com.hazelcast.map.impl.NullEntryView;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.merge.MapMergePolicy;
import com.hazelcast.spi.serialization.SerializationService;

public final class EntryViews {
    private EntryViews() {
    }

    public static <K, V> EntryView<K, V> createNullEntryView(K key) {
        return new NullEntryView(key);
    }

    public static <K, V> EntryView<K, V> createSimpleEntryView(K key, V value, Record record) {
        SimpleEntryView<K, V> simpleEntryView = new SimpleEntryView<K, V>(key, value);
        simpleEntryView.setCost(record.getCost());
        simpleEntryView.setVersion(record.getVersion());
        simpleEntryView.setHits(record.getHits());
        simpleEntryView.setLastAccessTime(record.getLastAccessTime());
        simpleEntryView.setLastUpdateTime(record.getLastUpdateTime());
        simpleEntryView.setTtl(record.getTtl());
        simpleEntryView.setCreationTime(record.getCreationTime());
        simpleEntryView.setExpirationTime(record.getExpirationTime());
        simpleEntryView.setLastStoredTime(record.getLastStoredTime());
        return simpleEntryView;
    }

    public static <K, V> EntryView<K, V> createSimpleEntryView() {
        return new SimpleEntryView();
    }

    public static <K, V> EntryView<K, V> createLazyEntryView(K key, V value, Record record, SerializationService serializationService, MapMergePolicy mergePolicy) {
        LazyEntryView<K, V> lazyEntryView = new LazyEntryView<K, V>(key, value, serializationService, mergePolicy);
        lazyEntryView.setCost(record.getCost());
        lazyEntryView.setVersion(record.getVersion());
        lazyEntryView.setHits(record.getHits());
        lazyEntryView.setLastAccessTime(record.getLastAccessTime());
        lazyEntryView.setLastUpdateTime(record.getLastUpdateTime());
        lazyEntryView.setTtl(record.getTtl());
        lazyEntryView.setCreationTime(record.getCreationTime());
        lazyEntryView.setExpirationTime(lazyEntryView.getExpirationTime());
        lazyEntryView.setLastStoredTime(lazyEntryView.getLastStoredTime());
        return lazyEntryView;
    }

    public static <K, V> EntryView<K, V> convertToLazyEntryView(EntryView entryView, SerializationService serializationService, MapMergePolicy mergePolicy) {
        LazyEntryView lazyEntryView = new LazyEntryView(entryView.getKey(), entryView.getValue(), serializationService, mergePolicy);
        lazyEntryView.setCost(entryView.getCost());
        lazyEntryView.setVersion(entryView.getVersion());
        lazyEntryView.setLastAccessTime(entryView.getLastAccessTime());
        lazyEntryView.setLastUpdateTime(entryView.getLastUpdateTime());
        lazyEntryView.setTtl(entryView.getTtl());
        lazyEntryView.setCreationTime(entryView.getCreationTime());
        lazyEntryView.setHits(entryView.getHits());
        lazyEntryView.setExpirationTime(entryView.getExpirationTime());
        lazyEntryView.setLastStoredTime(entryView.getLastStoredTime());
        return lazyEntryView;
    }
}

