/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.nearcache.impl.invalidation;

import com.hazelcast.internal.nearcache.NearCache;
import com.hazelcast.internal.nearcache.impl.DefaultNearCache;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataContainer;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataFetcher;
import com.hazelcast.internal.nearcache.impl.invalidation.MinimalPartitionService;
import com.hazelcast.internal.nearcache.impl.invalidation.RepairingHandler;
import com.hazelcast.internal.nearcache.impl.invalidation.StaleReadDetectorImpl;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.spi.properties.HazelcastProperties;
import com.hazelcast.spi.properties.HazelcastProperty;
import com.hazelcast.util.Preconditions;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;

public final class RepairingTask
implements Runnable {
    static final HazelcastProperty MAX_TOLERATED_MISS_COUNT = new HazelcastProperty("hazelcast.invalidation.max.tolerated.miss.count", 10);
    static final HazelcastProperty RECONCILIATION_INTERVAL_SECONDS = new HazelcastProperty("hazelcast.invalidation.reconciliation.interval.seconds", 60, TimeUnit.SECONDS);
    static final long GET_UUID_TASK_SCHEDULE_MILLIS = 500L;
    static final long HALF_MINUTE_MILLIS = TimeUnit.SECONDS.toMillis(30L);
    static final long MIN_RECONCILIATION_INTERVAL_SECONDS = 30L;
    final int maxToleratedMissCount;
    final long reconciliationIntervalNanos;
    private final int partitionCount;
    private final String localUuid;
    private final ILogger logger;
    private final ExecutionService executionService;
    private final AtomicReferenceArray<UUID> partitionUuids;
    private final MinimalPartitionService partitionService;
    private final MetaDataFetcher metaDataFetcher;
    private final ConcurrentMap<String, RepairingHandler> handlers = new ConcurrentHashMap<String, RepairingHandler>();
    private final AtomicBoolean running = new AtomicBoolean(false);
    private volatile long lastAntiEntropyRunNanos;

    public RepairingTask(MetaDataFetcher metaDataFetcher, ExecutionService executionService, MinimalPartitionService partitionService, HazelcastProperties properties, String localUuid, ILogger logger) {
        this.logger = logger;
        this.reconciliationIntervalNanos = TimeUnit.SECONDS.toNanos(this.checkAndGetReconciliationIntervalSeconds(properties));
        this.partitionCount = partitionService.getPartitionCount();
        this.maxToleratedMissCount = this.checkMaxToleratedMissCount(properties);
        this.metaDataFetcher = metaDataFetcher;
        this.executionService = executionService;
        this.partitionService = partitionService;
        this.partitionUuids = new AtomicReferenceArray(this.partitionCount);
        this.localUuid = localUuid;
    }

    private int checkMaxToleratedMissCount(HazelcastProperties properties) {
        int maxToleratedMissCount = properties.getInteger(MAX_TOLERATED_MISS_COUNT);
        return Preconditions.checkNotNegative(maxToleratedMissCount, String.format("max-tolerated-miss-count cannot be < 0 but found %d", maxToleratedMissCount));
    }

    private int checkAndGetReconciliationIntervalSeconds(HazelcastProperties properties) {
        int reconciliationIntervalSeconds = properties.getInteger(RECONCILIATION_INTERVAL_SECONDS);
        if (reconciliationIntervalSeconds < 0 || (long)reconciliationIntervalSeconds > 0L && (long)reconciliationIntervalSeconds < 30L) {
            String msg = String.format("Reconciliation interval can be at least %d seconds if it is not zero but found %d. Note that giving zero disables reconciliation task.", 30L, reconciliationIntervalSeconds);
            throw new IllegalArgumentException(msg);
        }
        return reconciliationIntervalSeconds;
    }

    @Override
    public void run() {
        try {
            this.fixSequenceGaps();
            this.runAntiEntropyIfNeeded();
        }
        finally {
            if (this.running.get()) {
                this.scheduleNextRun();
            }
        }
    }

    private void fixSequenceGaps() {
        for (RepairingHandler handler : this.handlers.values()) {
            if (!this.isAboveMaxToleratedMissCount(handler)) continue;
            this.updateLastKnownStaleSequences(handler);
        }
    }

    private void runAntiEntropyIfNeeded() {
        if (this.reconciliationIntervalNanos == 0L) {
            return;
        }
        long sinceLastRun = System.nanoTime() - this.lastAntiEntropyRunNanos;
        if (sinceLastRun >= this.reconciliationIntervalNanos) {
            this.metaDataFetcher.fetchMetadata(this.handlers);
            this.lastAntiEntropyRunNanos = System.nanoTime();
        }
    }

    private void scheduleNextRun() {
        block2: {
            try {
                this.executionService.schedule(this, 1L, TimeUnit.SECONDS);
            }
            catch (RejectedExecutionException e) {
                if (!this.logger.isFinestEnabled()) break block2;
                this.logger.finest(e.getMessage());
            }
        }
    }

    public <K, V> RepairingHandler registerAndGetHandler(String name, NearCache<K, V> nearCache) {
        boolean started = this.running.compareAndSet(false, true);
        if (started) {
            this.assignAndGetUuids();
        }
        RepairingHandler repairingHandler = new RepairingHandler(name, nearCache, this.partitionService, this.localUuid, this.logger);
        repairingHandler.initUnknownUuids(this.partitionUuids);
        StaleReadDetectorImpl staleReadDetector = new StaleReadDetectorImpl(repairingHandler, this.partitionService);
        nearCache.unwrap(DefaultNearCache.class).getNearCacheRecordStore().setStaleReadDetector(staleReadDetector);
        this.handlers.put(name, repairingHandler);
        if (started) {
            this.scheduleNextRun();
            this.lastAntiEntropyRunNanos = System.nanoTime();
        }
        return repairingHandler;
    }

    public void deregisterHandler(String mapName) {
        this.handlers.remove(mapName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assignAndGetUuids() {
        this.logger.finest("Making initial population of partition uuids");
        boolean initialized = false;
        try {
            List<Object> objects = this.metaDataFetcher.assignAndGetUuids();
            int i = 0;
            while (i < objects.size()) {
                Integer partition = (Integer)objects.get(i++);
                UUID uuid = (UUID)objects.get(i++);
                this.partitionUuids.set(partition, uuid);
                if (!this.logger.isFinestEnabled()) continue;
                this.logger.finest(partition + "-" + uuid);
            }
            initialized = true;
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        finally {
            if (!initialized) {
                this.assignAndGetUuidsAsync();
            }
        }
    }

    private void assignAndGetUuidsAsync() {
        this.executionService.schedule(new Runnable(){
            private final AtomicInteger round = new AtomicInteger();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                int roundNumber = this.round.incrementAndGet();
                boolean initialized = false;
                try {
                    RepairingTask.this.assignAndGetUuids();
                    for (RepairingHandler repairingHandler : RepairingTask.this.handlers.values()) {
                        repairingHandler.initUnknownUuids(RepairingTask.this.partitionUuids);
                    }
                    initialized = true;
                }
                catch (Exception e) {
                    if (RepairingTask.this.logger.isFinestEnabled()) {
                        RepairingTask.this.logger.finest(e);
                    }
                }
                finally {
                    if (!initialized) {
                        long delay = (long)roundNumber * 500L;
                        if (delay > HALF_MINUTE_MILLIS) {
                            this.round.set(0);
                        }
                        RepairingTask.this.executionService.schedule(this, delay, TimeUnit.MILLISECONDS);
                    }
                }
            }
        }, 500L, TimeUnit.MILLISECONDS);
    }

    private boolean isAboveMaxToleratedMissCount(RepairingHandler handler) {
        int partition = 0;
        long missCount = 0L;
        do {
            MetaDataContainer metaData;
            if ((missCount += (metaData = handler.getMetaDataContainer(partition)).getMissedSequenceCount()) <= (long)this.maxToleratedMissCount) continue;
            if (this.logger.isFinestEnabled()) {
                this.logger.finest(String.format("%s:[map=%s,missCount=%d,maxToleratedMissCount=%d]", "Above tolerated miss count", handler.getName(), missCount, this.maxToleratedMissCount));
            }
            return true;
        } while (++partition < this.partitionCount);
        return false;
    }

    private void updateLastKnownStaleSequences(RepairingHandler handler) {
        for (int partition = 0; partition < this.partitionCount; ++partition) {
            MetaDataContainer metaData = handler.getMetaDataContainer(partition);
            long missCount = metaData.getMissedSequenceCount();
            if (missCount == 0L) continue;
            metaData.addAndGetMissedSequenceCount(-missCount);
            handler.updateLastKnownStaleSequence(metaData, partition);
        }
    }

    public MetaDataFetcher getMetaDataFetcher() {
        return this.metaDataFetcher;
    }

    public ConcurrentMap<String, RepairingHandler> getHandlers() {
        return this.handlers;
    }

    public AtomicReferenceArray<UUID> getPartitionUuids() {
        return this.partitionUuids;
    }

    public String toString() {
        return "RepairingTask{}";
    }
}

