/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.adapter;

import com.hazelcast.core.ICompletableFuture;
import com.hazelcast.internal.adapter.DataStructureAdapter;
import com.hazelcast.internal.adapter.SimpleCompletedFuture;
import com.hazelcast.monitor.LocalMapStats;
import java.util.Map;
import java.util.Set;
import javax.cache.Cache;

public class ICacheDataStructureAdapter<K, V>
implements DataStructureAdapter<K, V> {
    private final Cache<K, V> cache;

    public ICacheDataStructureAdapter(Cache<K, V> cache) {
        this.cache = cache;
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public void set(K key, V value) {
        this.cache.put(key, value);
    }

    @Override
    public V put(K key, V value) {
        return (V)this.cache.getAndPut(key, value);
    }

    @Override
    public V get(K key) {
        return (V)this.cache.get(key);
    }

    @Override
    public ICompletableFuture<V> getAsync(K key) {
        return new SimpleCompletedFuture<Object>(this.cache.get(key));
    }

    @Override
    public void putAll(Map<K, V> map) {
        this.cache.putAll(map);
    }

    @Override
    public Map<K, V> getAll(Set<K> keys) {
        return this.cache.getAll(keys);
    }

    @Override
    public void remove(K key) {
        this.cache.remove(key);
    }

    @Override
    public LocalMapStats getLocalMapStats() {
        return null;
    }

    @Override
    public boolean containsKey(K key) {
        return this.cache.containsKey(key);
    }
}

