/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.instance;

import com.hazelcast.cluster.Joiner;
import com.hazelcast.instance.AddressPicker;
import com.hazelcast.instance.DefaultAddressPicker;
import com.hazelcast.instance.Node;
import com.hazelcast.instance.NodeContext;
import com.hazelcast.instance.NodeExtension;
import com.hazelcast.instance.NodeExtensionFactory;
import com.hazelcast.internal.networking.IOThreadingModel;
import com.hazelcast.internal.networking.nonblocking.NonBlockingIOThreadingModel;
import com.hazelcast.internal.networking.spinning.SpinningIOThreadingModel;
import com.hazelcast.logging.LoggingServiceImpl;
import com.hazelcast.nio.ConnectionManager;
import com.hazelcast.nio.NodeIOService;
import com.hazelcast.nio.tcp.SocketReaderInitializerImpl;
import com.hazelcast.nio.tcp.SocketWriterInitializerImpl;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.spi.annotation.PrivateApi;
import java.nio.channels.ServerSocketChannel;

@PrivateApi
public class DefaultNodeContext
implements NodeContext {
    @Override
    public NodeExtension createNodeExtension(Node node) {
        return NodeExtensionFactory.create(node);
    }

    @Override
    public AddressPicker createAddressPicker(Node node) {
        return new DefaultAddressPicker(node);
    }

    @Override
    public Joiner createJoiner(Node node) {
        return node.createJoiner();
    }

    @Override
    public ConnectionManager createConnectionManager(Node node, ServerSocketChannel serverSocketChannel) {
        NodeIOService ioService = new NodeIOService(node, node.nodeEngine);
        IOThreadingModel ioThreadingModel = this.createTcpIpConnectionThreadingModel(node, ioService);
        return new TcpIpConnectionManager(ioService, serverSocketChannel, node.loggingService, node.nodeEngine.getMetricsRegistry(), ioThreadingModel);
    }

    private IOThreadingModel createTcpIpConnectionThreadingModel(Node node, NodeIOService ioService) {
        boolean spinning = Boolean.getBoolean("hazelcast.io.spinning");
        LoggingServiceImpl loggingService = node.loggingService;
        SocketWriterInitializerImpl socketWriterInitializer = new SocketWriterInitializerImpl(loggingService.getLogger(SocketWriterInitializerImpl.class));
        SocketReaderInitializerImpl socketReaderInitializer = new SocketReaderInitializerImpl(loggingService.getLogger(SocketReaderInitializerImpl.class));
        if (spinning) {
            return new SpinningIOThreadingModel(loggingService, node.getHazelcastThreadGroup(), ioService.getIoOutOfMemoryHandler(), socketWriterInitializer, socketReaderInitializer);
        }
        return new NonBlockingIOThreadingModel(loggingService, node.nodeEngine.getMetricsRegistry(), node.getHazelcastThreadGroup(), ioService.getIoOutOfMemoryHandler(), ioService.getInputSelectorThreadCount(), ioService.getOutputSelectorThreadCount(), ioService.getBalancerIntervalSeconds(), socketWriterInitializer, socketReaderInitializer);
    }
}

