/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.scheduledexecutor;

import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.ScheduledExecutorGetStatsCodec;
import com.hazelcast.client.impl.protocol.task.AbstractInvocationMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.nio.Connection;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.ScheduledTaskStatistics;
import com.hazelcast.scheduledexecutor.impl.operations.GetStatisticsOperation;
import com.hazelcast.security.permission.ScheduledExecutorPermission;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.impl.operationservice.InternalOperationService;
import java.security.Permission;
import java.util.concurrent.TimeUnit;

public class ScheduledExecutorTaskGetStatisticsMessageTask
extends AbstractInvocationMessageTask<ScheduledExecutorGetStatsCodec.RequestParameters> {
    public ScheduledExecutorTaskGetStatisticsMessageTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        InternalOperationService operationService = this.nodeEngine.getOperationService();
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorGetStatsCodec.RequestParameters)this.parameters).handlerUrn);
        if (handler.getAddress() != null) {
            return operationService.createInvocationBuilder(this.getServiceName(), op, handler.getAddress());
        }
        return operationService.createInvocationBuilder(this.getServiceName(), op, handler.getPartitionId());
    }

    @Override
    protected Operation prepareOperation() {
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorGetStatsCodec.RequestParameters)this.parameters).handlerUrn);
        GetStatisticsOperation op = new GetStatisticsOperation(handler);
        op.setPartitionId(this.getPartitionId());
        return op;
    }

    @Override
    protected ScheduledExecutorGetStatsCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return ScheduledExecutorGetStatsCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        ScheduledTaskStatistics stats = (ScheduledTaskStatistics)response;
        return ScheduledExecutorGetStatsCodec.encodeResponse(stats.getLastIdleTime(TimeUnit.NANOSECONDS), stats.getTotalIdleTime(TimeUnit.NANOSECONDS), stats.getTotalRuns(), stats.getTotalRunTime(TimeUnit.NANOSECONDS));
    }

    @Override
    public String getServiceName() {
        return "hz:impl:scheduledExecutorService";
    }

    @Override
    public Permission getRequiredPermission() {
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorGetStatsCodec.RequestParameters)this.parameters).handlerUrn);
        return new ScheduledExecutorPermission(handler.getSchedulerName(), "read");
    }

    @Override
    public String getDistributedObjectName() {
        ScheduledTaskHandler handler = ScheduledTaskHandler.of(((ScheduledExecutorGetStatsCodec.RequestParameters)this.parameters).handlerUrn);
        return handler.getTaskName();
    }

    @Override
    public String getMethodName() {
        return "getStatistics";
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{((ScheduledExecutorGetStatsCodec.RequestParameters)this.parameters).handlerUrn};
    }
}

