/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.protocol.task.cache;

import com.hazelcast.cache.impl.CacheContext;
import com.hazelcast.cache.impl.CacheEventListener;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.impl.protocol.codec.CacheAddInvalidationListenerCodec;
import com.hazelcast.client.impl.protocol.task.AbstractCallableMessageTask;
import com.hazelcast.instance.Node;
import com.hazelcast.internal.nearcache.impl.invalidation.BatchNearCacheInvalidation;
import com.hazelcast.internal.nearcache.impl.invalidation.Invalidation;
import com.hazelcast.internal.nearcache.impl.invalidation.SingleNearCacheInvalidation;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.NotifiableEventListener;
import java.security.Permission;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CacheAddInvalidationListenerTask
extends AbstractCallableMessageTask<CacheAddInvalidationListenerCodec.RequestParameters> {
    public CacheAddInvalidationListenerTask(ClientMessage clientMessage, Node node, Connection connection) {
        super(clientMessage, node, connection);
    }

    @Override
    protected Object call() {
        ClientEndpoint endpoint = this.getEndpoint();
        CacheService cacheService = (CacheService)this.getService("hz:impl:cacheService");
        CacheContext cacheContext = cacheService.getOrCreateCacheContext(((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name);
        CacheInvalidationEventListener listener = new CacheInvalidationEventListener(endpoint, cacheContext);
        String registrationId = cacheService.addInvalidationListener(((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name, listener, ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).localOnly);
        endpoint.addListenerDestroyAction("hz:impl:cacheService", ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name, registrationId);
        return registrationId;
    }

    @Override
    protected CacheAddInvalidationListenerCodec.RequestParameters decodeClientMessage(ClientMessage clientMessage) {
        return CacheAddInvalidationListenerCodec.decodeRequest(clientMessage);
    }

    @Override
    protected ClientMessage encodeResponse(Object response) {
        return CacheAddInvalidationListenerCodec.encodeResponse((String)response);
    }

    @Override
    public String getDistributedObjectName() {
        return ((CacheAddInvalidationListenerCodec.RequestParameters)this.parameters).name;
    }

    @Override
    public String getMethodName() {
        return null;
    }

    @Override
    public Object[] getParameters() {
        return null;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    private final class CacheInvalidationEventListener
    implements CacheEventListener,
    NotifiableEventListener<CacheService> {
        private final ClientEndpoint endpoint;
        private final CacheContext cacheContext;
        private final int batchOrderKey;

        private CacheInvalidationEventListener(ClientEndpoint endpoint, CacheContext cacheContext) {
            this.batchOrderKey = CacheAddInvalidationListenerTask.this.nodeEngine.getLocalMember().hashCode();
            this.endpoint = endpoint;
            this.cacheContext = cacheContext;
        }

        @Override
        public void handleEvent(Object eventObject) {
            if (!this.endpoint.isAlive() || !(eventObject instanceof Invalidation)) {
                return;
            }
            this.sendInvalidation((Invalidation)eventObject);
        }

        private void sendInvalidation(Invalidation invalidation) {
            if (invalidation instanceof BatchNearCacheInvalidation) {
                ExtractedParams params = this.extractParams((BatchNearCacheInvalidation)invalidation);
                ClientMessage message = CacheAddInvalidationListenerCodec.encodeCacheBatchInvalidationEvent(invalidation.getName(), params.keys, params.sourceUuids, params.partitionUuids, params.sequences);
                CacheAddInvalidationListenerTask.this.sendClientMessage(this.batchOrderKey, message);
                return;
            }
            if (invalidation instanceof SingleNearCacheInvalidation) {
                ClientMessage message = CacheAddInvalidationListenerCodec.encodeCacheInvalidationEvent(invalidation.getName(), invalidation.getKey(), invalidation.getSourceUuid(), invalidation.getPartitionUuid(), invalidation.getSequence());
                CacheAddInvalidationListenerTask.this.sendClientMessage(invalidation.getKey(), message);
                return;
            }
            throw new IllegalArgumentException("Unknown invalidation message type " + invalidation);
        }

        private ExtractedParams extractParams(BatchNearCacheInvalidation batch) {
            List<Invalidation> invalidations = batch.getInvalidations();
            int size = invalidations.size();
            ArrayList<Data> keys = new ArrayList<Data>(size);
            ArrayList<String> sourceUuids = new ArrayList<String>(size);
            ArrayList<UUID> partitionUuids = new ArrayList<UUID>(size);
            ArrayList<Long> sequences = new ArrayList<Long>(size);
            for (Invalidation invalidation : invalidations) {
                keys.add(invalidation.getKey());
                sourceUuids.add(invalidation.getSourceUuid());
                partitionUuids.add(invalidation.getPartitionUuid());
                sequences.add(invalidation.getSequence());
            }
            return new ExtractedParams(keys, sourceUuids, partitionUuids, sequences);
        }

        @Override
        public void onRegister(CacheService cacheService, String serviceName, String topic, EventRegistration registration) {
            this.cacheContext.increaseInvalidationListenerCount();
        }

        @Override
        public void onDeregister(CacheService cacheService, String serviceName, String topic, EventRegistration registration) {
            this.cacheContext.decreaseInvalidationListenerCount();
        }

        private final class ExtractedParams {
            private final List<Data> keys;
            private final List<String> sourceUuids;
            private final List<UUID> partitionUuids;
            private final List<Long> sequences;

            public ExtractedParams(List<Data> keys, List<String> sourceUuids, List<UUID> partitionUuids, List<Long> sequences) {
                this.keys = keys;
                this.sourceUuids = sourceUuids;
                this.partitionUuids = partitionUuids;
                this.sequences = sequences;
            }
        }
    }
}

