/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.operation;

import com.hazelcast.cache.impl.CacheDataSerializerHook;
import com.hazelcast.cache.impl.CacheEventHandler;
import com.hazelcast.cache.impl.CacheService;
import com.hazelcast.internal.nearcache.impl.invalidation.MetaDataGenerator;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.Operation;
import com.hazelcast.spi.ReadonlyOperation;
import com.hazelcast.spi.partition.IPartitionService;
import com.hazelcast.util.CollectionUtil;
import com.hazelcast.util.Preconditions;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CacheGetInvalidationMetaDataOperation
extends Operation
implements IdentifiedDataSerializable,
ReadonlyOperation {
    private List<String> names;
    private MetaDataResponse response;

    public CacheGetInvalidationMetaDataOperation() {
    }

    public CacheGetInvalidationMetaDataOperation(List<String> names) {
        Preconditions.checkTrue(CollectionUtil.isNotEmpty(names), "names cannot be null or empty");
        this.names = names;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:cacheService";
    }

    @Override
    public void run() {
        List<Integer> ownedPartitions = this.getOwnedPartitions();
        this.response = new MetaDataResponse();
        this.response.partitionUuidList = this.getPartitionUuidList(ownedPartitions);
        this.response.namePartitionSequenceList = this.getNamePartitionSequenceList(ownedPartitions);
    }

    private List<Object> getNamePartitionSequenceList(List<Integer> ownedPartitionIds) {
        MetaDataGenerator metaDataGenerator = this.getPartitionMetaDataGenerator();
        ArrayList<Object> sequences = new ArrayList<Object>(ownedPartitionIds.size() * 2);
        for (String name : this.names) {
            int foundFirstSequence = 0;
            for (Integer partitionId : ownedPartitionIds) {
                long partitionSequence = metaDataGenerator.currentSequence(name, partitionId);
                if (partitionSequence == 0L) continue;
                if (foundFirstSequence == 0) {
                    sequences.add(name);
                    ++foundFirstSequence;
                }
                sequences.add(partitionId);
                sequences.add(partitionSequence);
            }
        }
        return sequences;
    }

    private List<Object> getPartitionUuidList(List<Integer> ownedPartitionIds) {
        MetaDataGenerator metaDataGenerator = this.getPartitionMetaDataGenerator();
        ArrayList<Object> partitionUuids = new ArrayList<Object>(ownedPartitionIds.size() * 2);
        for (Integer partitionId : ownedPartitionIds) {
            UUID uuid = metaDataGenerator.getUuidOrNull(partitionId);
            if (uuid == null) continue;
            partitionUuids.add(partitionId);
            partitionUuids.add(uuid.getMostSignificantBits());
            partitionUuids.add(uuid.getLeastSignificantBits());
        }
        return partitionUuids;
    }

    private List<Integer> getOwnedPartitions() {
        ArrayList<Integer> ownedPartitions = new ArrayList<Integer>();
        IPartitionService partitionService = this.getNodeEngine().getPartitionService();
        for (int i = 0; i < partitionService.getPartitionCount(); ++i) {
            if (!partitionService.isPartitionOwner(i)) continue;
            ownedPartitions.add(i);
        }
        return ownedPartitions;
    }

    private MetaDataGenerator getPartitionMetaDataGenerator() {
        CacheService cacheService = (CacheService)this.getService();
        CacheEventHandler cacheEventHandler = cacheService.getCacheEventHandler();
        return cacheEventHandler.getMetaDataGenerator();
    }

    @Override
    public Object getResponse() {
        return this.response;
    }

    @Override
    public void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeInt(this.names.size());
        for (String mapName : this.names) {
            out.writeUTF(mapName);
        }
    }

    @Override
    public void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        int size = in.readInt();
        ArrayList<String> mapNames = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            mapNames.add(in.readUTF());
        }
        this.names = mapNames;
    }

    @Override
    public int getFactoryId() {
        return CacheDataSerializerHook.F_ID;
    }

    @Override
    public int getId() {
        return 50;
    }

    public static class MetaDataResponse
    implements IdentifiedDataSerializable {
        private List<Object> namePartitionSequenceList;
        private List<Object> partitionUuidList;

        public MetaDataResponse() {
        }

        public MetaDataResponse(List<Object> namePartitionSequenceList, List<Object> partitionUuidList) {
            this.namePartitionSequenceList = namePartitionSequenceList;
            this.partitionUuidList = partitionUuidList;
        }

        public List<Object> getNamePartitionSequenceList() {
            return this.namePartitionSequenceList;
        }

        public List<Object> getPartitionUuidList() {
            return this.partitionUuidList;
        }

        @Override
        public int getFactoryId() {
            return CacheDataSerializerHook.F_ID;
        }

        @Override
        public int getId() {
            return 51;
        }

        @Override
        public void writeData(ObjectDataOutput out) throws IOException {
            out.writeInt(this.namePartitionSequenceList.size());
            for (Object o : this.namePartitionSequenceList) {
                out.writeObject(o);
            }
            out.writeInt(this.partitionUuidList.size());
            for (Object o : this.partitionUuidList) {
                out.writeObject(o);
            }
        }

        @Override
        public void readData(ObjectDataInput in) throws IOException {
            int size1 = in.readInt();
            this.namePartitionSequenceList = new ArrayList<Object>(size1);
            for (int i = 0; i < size1; ++i) {
                this.namePartitionSequenceList.add(in.readObject());
            }
            int size2 = in.readInt();
            this.partitionUuidList = new ArrayList<Object>(size2);
            for (int i = 0; i < size2; ++i) {
                this.partitionUuidList.add(in.readObject());
            }
        }
    }
}

