/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.aws.AWSClient;
import com.hazelcast.client.config.ClientAwsConfig;
import com.hazelcast.client.connection.AddressTranslator;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import com.hazelcast.nio.Address;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.Map;
import java.util.logging.Level;

public class AwsAddressTranslator
implements AddressTranslator {
    private final ILogger logger;
    private volatile Map<String, String> privateToPublic;
    private final AWSClient awsClient;
    private final boolean isInsideAws;

    public AwsAddressTranslator(ClientAwsConfig awsConfig, LoggingService loggingService) {
        this.awsClient = new AWSClient(awsConfig);
        this.isInsideAws = awsConfig.isInsideAws();
        this.logger = loggingService.getLogger(AwsAddressTranslator.class);
    }

    @Override
    public Address translate(Address address) {
        if (this.isInsideAws) {
            return address;
        }
        if (address == null) {
            return null;
        }
        String publicAddress = this.getLookupTable().get(address.getHost());
        if (publicAddress != null) {
            return this.constructPrivateAddress(publicAddress, address);
        }
        this.refresh();
        publicAddress = this.getLookupTable().get(address.getHost());
        if (publicAddress != null) {
            return this.constructPrivateAddress(publicAddress, address);
        }
        return null;
    }

    private Address constructPrivateAddress(String privateAddress, Address address) {
        try {
            return new Address(privateAddress, address.getPort());
        }
        catch (UnknownHostException e) {
            return null;
        }
    }

    private Map<String, String> getLookupTable() {
        Map<String, String> table = this.privateToPublic;
        return table != null ? table : Collections.emptyMap();
    }

    @Override
    public void refresh() {
        try {
            this.privateToPublic = this.awsClient.getAddresses();
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, "Aws addresses are failed to load : " + e.getMessage());
        }
    }
}

