/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl;

import com.hazelcast.cache.impl.AbstractCacheService;
import com.hazelcast.cache.impl.ICacheRecordStore;
import com.hazelcast.config.CacheConfig;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class CachePartitionSegment
implements ConstructorFunction<String, ICacheRecordStore> {
    protected final AbstractCacheService cacheService;
    protected final int partitionId;
    protected final ConcurrentMap<String, ICacheRecordStore> recordStores = new ConcurrentHashMap<String, ICacheRecordStore>();
    protected final Object mutex = new Object();

    public CachePartitionSegment(AbstractCacheService cacheService, int partitionId) {
        this.cacheService = cacheService;
        this.partitionId = partitionId;
    }

    @Override
    public ICacheRecordStore createNew(String name) {
        return this.cacheService.createNewRecordStore(name, this.partitionId);
    }

    public Iterator<ICacheRecordStore> recordStoreIterator() {
        return this.recordStores.values().iterator();
    }

    public Collection<CacheConfig> getCacheConfigs() {
        return this.cacheService.getCacheConfigs();
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public ICacheRecordStore getOrCreateRecordStore(String name) {
        return ConcurrencyUtil.getOrPutSynchronized(this.recordStores, name, this.mutex, this);
    }

    public ICacheRecordStore getRecordStore(String name) {
        return (ICacheRecordStore)this.recordStores.get(name);
    }

    public void deleteRecordStore(String name, boolean destroy) {
        if (destroy) {
            ICacheRecordStore store = (ICacheRecordStore)this.recordStores.remove(name);
            if (store != null) {
                store.destroy();
            }
        } else {
            ICacheRecordStore store = (ICacheRecordStore)this.recordStores.get(name);
            if (store != null) {
                store.close(false);
            }
        }
    }

    public boolean hasAnyRecordStore() {
        return !this.recordStores.isEmpty();
    }

    public boolean hasRecordStore(String name) {
        return this.recordStores.containsKey(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() {
        Object object = this.mutex;
        synchronized (object) {
            for (ICacheRecordStore store : this.recordStores.values()) {
                store.init();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.mutex;
        synchronized (object) {
            for (ICacheRecordStore store : this.recordStores.values()) {
                store.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this.mutex;
        synchronized (object) {
            for (ICacheRecordStore store : this.recordStores.values()) {
                store.close(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearHavingLesserBackupCountThan(int backupCount) {
        Object object = this.mutex;
        synchronized (object) {
            for (ICacheRecordStore store : this.recordStores.values()) {
                CacheConfig cacheConfig = store.getConfig();
                if (backupCount <= cacheConfig.getTotalBackupCount()) continue;
                store.clear();
            }
        }
    }
}

