/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio;

import com.hazelcast.spi.annotation.PrivateApi;
import com.hazelcast.util.ConcurrentReferenceHashMap;
import com.hazelcast.util.EmptyStatement;
import com.hazelcast.util.Preconditions;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@PrivateApi
public final class ClassLoaderUtil {
    public static final String HAZELCAST_BASE_PACKAGE = "com.hazelcast.";
    public static final String HAZELCAST_ARRAY = "[Lcom.hazelcast.";
    private static final boolean CLASS_CACHE_DISABLED = Boolean.getBoolean("hazelcast.compat.classloading.cache.disabled");
    private static final Map<String, Class> PRIMITIVE_CLASSES;
    private static final int MAX_PRIM_CLASSNAME_LENGTH = 7;
    private static final ClassLoaderWeakCache<Constructor> CONSTRUCTOR_CACHE;
    private static final ClassLoaderWeakCache<Class> CLASS_CACHE;

    private ClassLoaderUtil() {
    }

    public static <T> T newInstance(ClassLoader classLoader, String className) throws Exception {
        Constructor constructor = CONSTRUCTOR_CACHE.get(classLoader = classLoader == null ? ClassLoaderUtil.class.getClassLoader() : classLoader, className);
        if (constructor != null) {
            return constructor.newInstance(new Object[0]);
        }
        Class<?> klass = ClassLoaderUtil.loadClass(classLoader, className);
        return (T)ClassLoaderUtil.newInstance(klass, classLoader, className);
    }

    public static <T> T newInstance(Class<T> klass, ClassLoader classLoader, String className) throws Exception {
        Constructor<T> constructor = klass.getDeclaredConstructor(new Class[0]);
        if (!constructor.isAccessible()) {
            constructor.setAccessible(true);
        }
        ((ClassLoaderWeakCache)ClassLoaderUtil.CONSTRUCTOR_CACHE).put(classLoader, className, constructor);
        return constructor.newInstance(new Object[0]);
    }

    public static Class<?> loadClass(ClassLoader classLoader, String className) throws ClassNotFoundException {
        Class primitiveClass;
        Preconditions.isNotNull(className, "className");
        if (className.length() <= 7 && Character.isLowerCase(className.charAt(0)) && (primitiveClass = PRIMITIVE_CLASSES.get(className)) != null) {
            return primitiveClass;
        }
        ClassLoader theClassLoader = classLoader;
        if (theClassLoader == null) {
            theClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (theClassLoader != null) {
            try {
                return ClassLoaderUtil.tryLoadClass(className, theClassLoader);
            }
            catch (ClassNotFoundException ignore) {
                theClassLoader = null;
            }
        }
        if (className.startsWith(HAZELCAST_BASE_PACKAGE) || className.startsWith(HAZELCAST_ARRAY)) {
            theClassLoader = ClassLoaderUtil.class.getClassLoader();
        }
        if (theClassLoader == null) {
            theClassLoader = Thread.currentThread().getContextClassLoader();
        }
        if (theClassLoader != null) {
            return ClassLoaderUtil.tryLoadClass(className, theClassLoader);
        }
        return Class.forName(className);
    }

    public static boolean isClassAvailable(ClassLoader classLoader, String className) {
        try {
            Class<?> clazz = ClassLoaderUtil.loadClass(classLoader, className);
            return clazz != null;
        }
        catch (ClassNotFoundException e) {
            EmptyStatement.ignore(e);
            return false;
        }
    }

    private static Class<?> tryLoadClass(String className, ClassLoader classLoader) throws ClassNotFoundException {
        Class<?> clazz;
        if (!CLASS_CACHE_DISABLED && (clazz = CLASS_CACHE.get(classLoader, className)) != null) {
            return clazz;
        }
        clazz = className.startsWith("[") ? Class.forName(className, false, classLoader) : classLoader.loadClass(className);
        if (!CLASS_CACHE_DISABLED) {
            ((ClassLoaderWeakCache)ClassLoaderUtil.CLASS_CACHE).put(classLoader, className, clazz);
        }
        return clazz;
    }

    public static boolean isInternalType(Class type) {
        String name = type.getName();
        ClassLoader classLoader = ClassLoaderUtil.class.getClassLoader();
        return type.getClassLoader() == classLoader && name.startsWith(HAZELCAST_BASE_PACKAGE);
    }

    public static Class<?> tryLoadClass(String className) throws ClassNotFoundException {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            return contextClassLoader.loadClass(className);
        }
    }

    public static boolean isClassDefined(String className) {
        try {
            ClassLoaderUtil.tryLoadClass(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    static {
        CONSTRUCTOR_CACHE = new ClassLoaderWeakCache();
        CLASS_CACHE = new ClassLoaderWeakCache();
        HashMap<String, Class<Object>> primitives = new HashMap<String, Class<Object>>(10, 1.0f);
        primitives.put("boolean", Boolean.TYPE);
        primitives.put("byte", Byte.TYPE);
        primitives.put("int", Integer.TYPE);
        primitives.put("long", Long.TYPE);
        primitives.put("short", Short.TYPE);
        primitives.put("float", Float.TYPE);
        primitives.put("double", Double.TYPE);
        primitives.put("char", Character.TYPE);
        primitives.put("void", Void.TYPE);
        PRIMITIVE_CLASSES = Collections.unmodifiableMap(primitives);
    }

    private static final class ClassLoaderWeakCache<V> {
        private final ConcurrentMap<ClassLoader, ConcurrentMap<String, WeakReference<V>>> cache = new ConcurrentReferenceHashMap<ClassLoader, ConcurrentMap<String, WeakReference<V>>>(16);

        private ClassLoaderWeakCache() {
        }

        private V put(ClassLoader classLoader, String className, V value) {
            ConcurrentMap old;
            ClassLoader cl = classLoader == null ? ClassLoaderUtil.class.getClassLoader() : classLoader;
            ConcurrentMap<String, WeakReference<V>> innerCache = (ConcurrentHashMap<String, WeakReference<V>>)this.cache.get(cl);
            if (innerCache == null && (old = (ConcurrentMap)this.cache.putIfAbsent(cl, innerCache = new ConcurrentHashMap<String, WeakReference<V>>(100))) != null) {
                innerCache = old;
            }
            innerCache.put(className, new WeakReference<V>(value));
            return value;
        }

        public V get(ClassLoader classloader, String className) {
            V value;
            Preconditions.isNotNull(className, "className");
            ConcurrentMap innerCache = (ConcurrentMap)this.cache.get(classloader);
            if (innerCache == null) {
                return null;
            }
            WeakReference reference = (WeakReference)innerCache.get(className);
            V v = value = reference == null ? null : (V)reference.get();
            if (reference != null && value == null) {
                innerCache.remove(className);
            }
            return value;
        }
    }
}

